<?php $__env->startSection('content'); ?>
<div class="card">
    <form class="card-body" id="filter-form">
        <div class="row">
            <div class="col-md-4">
                <label>Date</label>
                <input type="date" class="form-control" name="date">
            </div>
            <div class="col-md-4">
                <label>Customer</label>
                <select class="select2" name="customer_id">
                    <option></option>
                    <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($customer->id); ?>"><?php echo e($customer->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <div class="col-md-4">
                <label>Branch</label>
                <select class="select2" name="branch_id">
                    <option></option>
                    <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($branch->id); ?>"><?php echo e($branch->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <div class="text-end">
                    <button type="submit" class="btn btn-success">Search</button>
                </div>
            </div>
        </div>
    </form>
</div>

<div class="card">
    <div class="card-header">
        <h5 class="card-title">Discounts</h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table dataTable table-striped" id="discounts-table">
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Branch</th>
                        <th>Customer</th>
                        <th>Inventory Item</th>
                        <th>Rate</th>
                        <th>Quantity</th>
                        <th>Amount</th>
                    </tr>
                </thead>
                <tbody>
                    <!-- Data will be populated here via AJAX -->
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('customjs'); ?>
<script>
$(document).ready(function() {
    // Initialize Select2 for dropdowns
    $('.select2').select2();

    // Initialize DataTable with server-side processing
    let table = $('#discounts-table').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: "<?php echo e(route('discounts.index')); ?>",
            data: function(d) {
                d.date = $('input[name="date"]').val();
                d.customer_id = $('select[name="customer_id"]').val();
                d.branch_id = $('select[name="branch_id"]').val();
            }
        },
        columns: [
            { data: 'date', name: 'date' },
            { data: 'branch_name', name: 'branch_name' },
            { data: 'customer_name', name: 'customer_name' },
            { data: 'inventory_name', name: 'inventory_name' },
            { data: 'discount_rate', name: 'discount_rate' },
            { data: 'quantity', name: 'quantity' },
            { data: 'total_discount', name: 'total_discount' }
        ]
    });

    // Trigger table reload when the form is submitted
    $('#filter-form').on('submit', function(e) {
        e.preventDefault();
        table.ajax.reload(); // Reload the DataTable with new filter values
    });
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/angus/public_html/warmth/resources/views/discounts/index.blade.php ENDPATH**/ ?>