<?php $__env->startSection('breadcrumb'); ?>
<div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
    <h4 class="mb-sm-0">Daily Summaries</h4>
    <div class="page-title-right">
        <ol class="breadcrumb m-0">
            <li class="breadcrumb-item"><a href="<?php echo e(url('dashboard')); ?>">Dashboard</a></li>
            <li class="breadcrumb-item"><a href="<?php echo e(url('summaries')); ?>">Daily Summaries</a></li>
            <li class="breadcrumb-item"><a href="javascript:void(0);"><?php echo e($summary->branch?->name); ?></a></li>
            <li class="breadcrumb-item"><a href="<?php echo e(url('summaries/modules/'.$summary->id)); ?>"><?php echo e(date('d M, Y',strtotime($summary->date))); ?></a></li>
            <li class="breadcrumb-item active">Summarisation</li>
        </ol>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="card">
	<div class="card-header">
		<h5>Day Summary</h5>
	</div>
	<div class="card-body">
		<h6 class="text-center fs-17">Summary</h6>
		<table class="table table-bordered border-secondary table-nowrap">
			<thead>
				<th>Opening Balance</th>
				<th>Added Stock</th>
				<th>Profits</th>
				<th>Gross Sales</th>
				<th>Tranfers</th>
				<th>Closing Balance</th>
			</thead>
			<tbody>
				<tr>
					<td><?php echo e(number_format($summary->opening_balance,2)); ?></td>
					<td><?php echo e(number_format($summary->intake,2)); ?></td>
					<td><?php echo e(number_format($summary->profits_total)); ?></td>
					<td><?php echo e(number_format($summary->total_sales,2)); ?></td>
					<td><?php echo e(number_format($summary->transfers,2)); ?></td>
					<td><?php echo e(number_format($summary->closing_balance)); ?></td>
				</tr>
			</tbody>
		</table>
		<h6 class="text-center fs-17">Collections</h6>
		<table class="table table-bordered border-secondary table-nowrap">
			<thead>
				<tr>
					<th scope="col">Personel</th>
					<th>Reason</th>
					<th scope="col">Amount</th>
				</tr>
			</thead>
			<tbody>
				<?php $__currentLoopData = $summary->collections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $collection): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					<tr>
						<td><?php echo e(($collection->personel_id) ? $collection->personel?->name :$collection->customer?->name); ?></td>
						<td><?php echo e($collection->reason); ?></td>
						<td><?php echo e(number_format($collection->amount,2)); ?></td>
					</tr>
				<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				<tr class="">
					<td colspan="2" class="text-end fw-22">Total</td>
					<td><?php echo e(number_format($summary->cash_sales,2)); ?></td>
				</tr>
			</tbody>
		</table>
		<h6 class="text-center fs-17">Credits</h6>
		<table class="table table-bordered border-secondary table-nowrap">
			<thead>
				<tr>
					<th scope="col">Customer</th>
					<th>Receipt No.</th>
					<th scope="col">Amount</th>
				</tr>
			</thead>
			<tbody>
				<?php $__currentLoopData = $summary->credits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $credit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					<tr>
						<td><?php echo e($credit->customer?->name); ?></td>
						<td><?php echo e($credit->receipt_no); ?></td>
						<td><?php echo e(number_format($credit->amount,2)); ?></td>
					</tr>
				<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				<tr>
					<td colspan="2" class="text-end">Total</td>
					<td><?php echo e(number_format($summary->credit_sales,2)); ?></td>
				</tr>
			</tbody>
		</table>
		<h6 class="text-center fs-17">Discounts</h6>
		<table class="table table-bordered border-secondary table-nowrap">
			<thead>
				<tr>
					<th scope="col">Customer</th>
					<th scope="col">Inventory</th>
					<th scope="col">Rate</th>
					<th scope="col">Quantity</th>
					<th scope="col">Amount</th>
				</tr>
			</thead>
			<tbody>
				<?php $__currentLoopData = $summary->summary_discounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $discount): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					<tr>
						<td><?php echo e($discount->customer?->name); ?></td>
						<td><?php echo e($discount->inventory?->name); ?></td>
						<td><?php echo e(number_format($discount->discount_rate)); ?></td>
						<td><?php echo e(number_format($discount->quantity)); ?></td>
						<td><?php echo e(number_format($discount->total_discount,2)); ?></td>
					</tr>
				<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				<tr>
					<td colspan="4" class="text-end">Total</td>
					<td><?php echo e(number_format($summary->discounts,2)); ?></td>
				</tr>
			</tbody>
		</table>
		<h6 class="text-center fs-17">Intakes</h6>
		<table class="table table-bordered border-secondary table-nowrap">
			<thead>
				<tr>
					<th scope="col">Source</th>
					<th scope="col">Inventory</th>
					<th scope="col">Rate</th>
					<th scope="col">Quantity</th>
					<th scope="col">Amount</th>
				</tr>
			</thead>
			<tbody>
				<?php $__currentLoopData = $summary->intakes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $intake): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					<tr>
						<td><?php echo e(($intake->supplier_id) ? $intake->supplier?->name : $intake->branch?->name); ?></td>
						<td><?php echo e($intake->inventory?->name); ?></td>
						<td><?php echo e(number_format($intake->rate)); ?></td>
						<td><?php echo e(number_format($intake->quantity)); ?></td>
						<td><?php echo e(number_format($intake->amount,2)); ?></td>
					</tr>
				<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				<tr>
					<td colspan="4" class="text-end">Total</td>
					<td><?php echo e(number_format($summary->intake,2)); ?></td>
				</tr>
			</tbody>
		</table>
		<h6 class="text-center fs-17">Transfers</h6>
		<table class="table table-bordered border-secondary table-nowrap">
			<thead>
				<tr>
					<th scope="col">Destination</th>
					<th scope="col">Inventory</th>
					<th scope="col">Rate</th>
					<th scope="col">Quantity</th>
					<th scope="col">Amount</th>
				</tr>
			</thead>
			<tbody>
				<?php $__currentLoopData = $summary->summary_transfers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transfer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					<tr>
						<td><?php echo e($transfer->destination?->name); ?></td>
						<td><?php echo e($transfer->inventory?->name); ?></td>
						<td><?php echo e(number_format($transfer->rate)); ?></td>
						<td><?php echo e(number_format($transfer->quantity)); ?></td>
						<td><?php echo e(number_format($transfer->amount,2)); ?></td>
					</tr>
				<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				<tr>
					<td colspan="4" class="text-end">Total</td>
					<td><?php echo e(number_format($summary->transfers,2)); ?></td>
				</tr>
			</tbody>
		</table>
		<h6 class="text-center fs-17">Recoveries</h6>
		<table class="table table-bordered border-secondary table-nowrap">
			<thead>
				<tr>
					<th scope="col">Personel</th>
					<th scope="col">Customer</th>
					<th>Amount</th>
				</tr>
			</thead>
			<tbody>
				<?php $__currentLoopData = $summary->recoveries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $recovery): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					<tr>
						<td><?php echo e($recovery->personel?->name); ?></td>
						<td><?php echo e($recovery->customer?->name); ?></td>
						<td><?php echo e(number_format($recovery->amount,2)); ?></td>
					</tr>
				<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				<tr>
					<td class="text-end">Total</td>
					<td></td>
					<td><?php echo e(number_format($summary->total_recoveries,2)); ?></td>
				</tr>
			</tbody>
		</table>
		<h6 class="text-center fs-17">Expenses</h6>
		<table class="table table-bordered border-secondary table-nowrap">
			<thead>
				<tr>
					<th scope="col">Item</th>
					<th scope="col">Amount</th>
				</tr>
			</thead>
			<tbody>
				<?php $__currentLoopData = $summary->summary_expenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $expense): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					<tr>
						<td><?php echo e($expense->expense_item?->name); ?></td>
						<td><?php echo e(number_format($expense->amount,2)); ?></td>
					</tr>
				<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				<tr>
					<td class="text-end">Total</td>
					<td><?php echo e(number_format($summary->expenses,2)); ?></td>
				</tr>
			</tbody>
		</table>
	</div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/angus/public_html/warmth/resources/views/summaries/show.blade.php ENDPATH**/ ?>