<?php $__env->startSection('breadcrumb'); ?>
<div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
	<h4 class="mb-sm-0">Users</h4>
	<div class="page-title-right">
		<ol class="breadcrumb m-0">
			<li class="breadcrumb-item"><a href="<?php echo e(url('dashboard')); ?>">Dashboard</a></li>
			<li class="breadcrumb-item active">Users</li>
		</ol>
	</div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="card">
	<div class="card-header d-flex flex-row align-items-center justify-content-between">
		<h4>Users</h4>
		<a href="<?php echo e(url('users/create')); ?>" class="btn btn-primary">Add New User</a>
	</div>
	<div class="card-body">
		<div class="table-responsive">
			<table class="table dataTable">
				<thead>
					<th>Name</th>
					<th>Email</th>
					<th></th>
				</thead>
				<tbody>
					<?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<tr>
							<td><?php echo e(ucwords($user->name)); ?></td>
							<td><?php echo e($user->email); ?></td>
							<td>
								<a class="btn btn-primary btn-sm" href="<?php echo e(url('users/'.$user->id)); ?>">Show</a>
								<div class="btn-group btn-group-sm">
		                            <button type="button" class="btn btn-light dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false"><i class="fa fa-cog"></i></button>
		                            <ul class="dropdown-menu">
		                                <li><a class="dropdown-item" href="<?php echo e(route('users.edit', compact('user'))); ?>"><?php echo app('translator')->get('Edit'); ?></a></li>
		                                <li>
		                                    <form action="<?php echo e(route('users.destroy', compact('user'))); ?>" method="POST" style="display: inline;" class="m-0 p-0">
		                                        <?php echo csrf_field(); ?>
		                                        <?php echo method_field('DELETE'); ?>
		                                        <button type="submit" class="dropdown-item"><?php echo app('translator')->get('Delete'); ?></button>
		                                    </form>
		                                </li>
		                            </ul>
		                        </div>
							</td>
						</tr>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				</tbody>
			</table>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/angus/public_html/warmth/resources/views/users/index.blade.php ENDPATH**/ ?>