<?php $__env->startSection('breadcrumb'); ?>
<div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
    <h4 class="mb-sm-0">Daily Summaries</h4>
    <div class="page-title-right">
        <ol class="breadcrumb m-0">
            <li class="breadcrumb-item"><a href="<?php echo e(url('dashboard')); ?>">Dashboard</a></li>
            <li class="breadcrumb-item"><a href="<?php echo e(url('summaries')); ?>">Daily Summaries</a></li>
            <li class="breadcrumb-item"><a href="javascript:void(0);"><?php echo e($summary->branch?->name); ?></a></li>
            <li class="breadcrumb-item"><a href="<?php echo e(url('summaries/modules/'.$summary->id)); ?>"><?php echo e(date('d M, Y',strtotime($summary->date))); ?></a></li>
            <li class="breadcrumb-item active">Expenses</li>
        </ol>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-header">
        <?php echo $__env->make('layouts.summaries_menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
    <div class="card-body">
        <form action="<?php echo e(url('expenses')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="summary_id" value="<?php echo e($summary->id); ?>">
            
            <div class="repeater">
                <table class="table">
                    <thead>
                        <th>Expense Item</th>
                        <th>Amount</th>
                    </thead>
                    <tbody data-repeater-list="items">
                        <tr data-repeater-item>
                            <td>
                                <select class="form-control form-select select2" name="expense_item_id" required>
                                        <option></option>
                                        <?php $__currentLoopData = $expense_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $expense_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($expense_item->id); ?>"><?php echo e($expense_item->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                            </td>
                            <td>
                                <input type="number" name="amount" class="form-control amount" required>
                                <div class="text-end">
                                    <button type="button" data-repeater-delete class="btn btn-danger">Delete</button>
                                </div>
                            </td>
                        </tr>
                    </tbody>
                </table>
                <button type="button" data-repeater-create class="btn btn-primary">Add</button>
            </div>
            <div class="mt-4">
                <div class="row">
                    <div class="col-md-3 offset-md-9">
                        <div class="form-group">
                            <label for="grand-total">Grand Total:</label>
                            <input type="text" id="grand-total" class="form-control" disabled>
                        </div>
                    </div>
                </div>
            </div>
            <div class="d-flex flex-row align-items-center justify-content-between">
                <a href="<?php echo e(url('transfers/create')); ?>?summary_id=<?php echo e($summary->id); ?>" class="btn btn-info">Cancel</a>
                <button type="submit" class="btn btn-success">Save</button>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('customjs'); ?>
<script type="text/javascript">
    $(document).ready(function () {
                $('.select2').select2()
        var $repeater = $('.repeater').repeater({
            initEmpty: true,
            show: function () {
                $(this).slideDown();
                $('.select2-container').remove();
                $('.select2').select2()
                bindEvents($(this));
            },
            hide: function (deleteElement) {
                $(this).slideUp(deleteElement, function() {
                    $(this).remove();
                    calculateGrandTotal();
                });
            }
        });

        <?php if(old('items')): ?>
            $repeater.setList(<?php echo json_encode(old('items'), 15, 512) ?>);
        <?php elseif($expenses->count() > 0): ?>
            $repeater.setList([
                <?php $__currentLoopData = $expenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $expense): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    {
                        expense_item_id: '<?php echo e($expense->expense_item_id); ?>',
                        amount: '<?php echo e($expense->amount); ?>',
                    },
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            ]);
        <?php endif; ?>

        calculateGrandTotal();

        // Bind the event functions to all initial repeater items
        $('.repeater [data-repeater-item]').each(function() {
            bindEvents($(this));
        });

        function bindEvents(item) {
            item.find('.inventory-select').on('change', function() {
                var selectedRate = $(this).find(':selected').data('rate') || 0;
                item.find('.amount').val(selectedRate).trigger('input');
            });

            item.find('.amount').on('input', function() {
                var amount = parseFloat(item.find('.amount').val()) || 0;
                // var quantity = parseFloat(item.find('.quantity').val()) || 0;
                // var total = rate * quantity;
                // item.find('.total').val(total);
                calculateGrandTotal();
            });
        }

        function calculateGrandTotal() {
            var grandTotal = 0;
            $('.repeater .amount').each(function() {
                var total = parseFloat($(this).val()) || 0;
                grandTotal += total;
            });
            $('#grand-total').val(grandTotal.toLocaleString());
        }
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/angus/public_html/warmth/resources/views/expenses/create.blade.php ENDPATH**/ ?>