<?php $__env->startSection('inventories.content'); ?>
    <div class="container">
        <div class="card">
            <div class="card-header d-flex flex-row align-items-center justify-content-between">
                <ol class="breadcrumb m-0 p-0">
                    <li class="breadcrumb-item"><a href="<?php echo e(implode('/', ['','inventories'])); ?>"> Inventories</a></li>
                    <li class="breadcrumb-item"><?php echo app('translator')->get('Inventory'); ?> #<?php echo e($inventory->id); ?></li>
                </ol>

                <a href="<?php echo e(route('inventories.index', [])); ?>" class="btn btn-light"><i class="fa fa-caret-left"></i> Back</a>
            </div>

            <div class="card-body">
                <table class="table table-striped">
    <tbody>
    <tr>
        <th scope="row">ID:</th>
        <td><?php echo e($inventory->id); ?></td>
    </tr>
            <tr>
            <th scope="row">Name:</th>
            <td><?php echo e($inventory->name ?: "-"); ?></td>
        </tr>
            <tr>
            <th scope="row">Rate:</th>
            <td><?php echo e($inventory->rate ?: "-"); ?></td>
        </tr>
                <tr>
            <th scope="row">Created at</th>
            <td><?php echo e(Carbon\Carbon::parse($inventory->created_at)->format('d/m/Y H:i:s')); ?></td>
        </tr>
        <tr>
            <th scope="row">Updated at</th>
            <td><?php echo e(Carbon\Carbon::parse($inventory->updated_at)->format('d/m/Y H:i:s')); ?></td>
        </tr>
        </tbody>
</table>

            </div>

            <div class="card-footer d-flex flex-column flex-md-row align-items-center justify-content-end">
                <a href="<?php echo e(route('inventories.edit', compact('inventory'))); ?>" class="btn btn-info text-nowrap me-1"><i class="fa fa-edit"></i> <?php echo app('translator')->get('Edit'); ?></a>
                <form action="<?php echo e(route('inventories.destroy', compact('inventory'))); ?>" method="POST" class="m-0 p-0">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button type="submit" class="btn btn-danger text-nowrap"><i class="fa fa-trash"></i> <?php echo app('translator')->get('Delete'); ?></button>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('inventories.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/angus/public_html/warmth/resources/views/inventories/show.blade.php ENDPATH**/ ?>