<?php $__env->startSection('breadcrumb'); ?>
<div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
	<h4 class="mb-sm-0">Daily Summaries</h4>
	<div class="page-title-right">
		<ol class="breadcrumb m-0">
			<li class="breadcrumb-item"><a href="<?php echo e(url('dashboard')); ?>">Dashboard</a></li>
			<li class="breadcrumb-item"><a href="<?php echo e(url('summaries')); ?>">Daily Summaries</a></li>
			<li class="breadcrumb-item"><a href="javascript:void(0);"><?php echo e($summary->branch?->name); ?></a></li>
			<li class="breadcrumb-item"><a href="<?php echo e(url('summaries/modules/'.$summary->id)); ?>"><?php echo e(date('d M, Y',strtotime($summary->date))); ?></a></li>
			<li class="breadcrumb-item active">Modules</li>
		</ol>
	</div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="row">
	<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create collections')): ?>
	<div class="col-md-6">
		<a href="<?php echo e(url('collections/create')); ?>?summary_id=<?php echo e($summary->id); ?>" class="card">
			<div class="card-body">
				<h4>Collections</h4>
				<h6><?php echo e(number_format($summary->collections_sum_amount)); ?></h6>
			</div>
		</a>
	</div>
	<?php endif; ?>
	<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create credits')): ?>
	<div class="col-md-6">
		<a href="<?php echo e(url('credits/create')); ?>?summary_id=<?php echo e($summary->id); ?>" class="card">
			<div class="card-body">
				<h4>Credits</h4>
				<h6><?php echo e(number_format($summary->credits_sum_amount)); ?></h6>
			</div>
		</a>
	</div>
	<?php endif; ?>
	<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create discounts')): ?>
	<div class="col-md-6">
		<a href="<?php echo e(url('discounts/create')); ?>?summary_id=<?php echo e($summary->id); ?>" class="card">
			<div class="card-body">
				<h4>Discounts</h4>
				<h6><?php echo e(number_format($summary->summary_discounts_sum_total_discount)); ?></h6>
			</div>
		</a>
	</div>
	<?php endif; ?>
	<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create intakes')): ?>
	<div class="col-md-6">
		<a href="<?php echo e(url('intakes/create')); ?>?summary_id=<?php echo e($summary->id); ?>" class="card">
			<div class="card-body">
				<h4>Intakes</h4>
				<h6><?php echo e(number_format($summary->intakes_sum_amount)); ?></h6>
			</div>
		</a>
	</div>
	<?php endif; ?>
	<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create transfers')): ?>
	<div class="col-md-6">
		<a href="<?php echo e(url('transfers/create')); ?>?summary_id=<?php echo e($summary->id); ?>" class="card">
			<div class="card-body">
				<h4>Outward Transfers</h4>
				<h6><?php echo e(number_format($summary->summary_transfers_sum_amount)); ?></h6>
			</div>
		</a>
	</div>
	<?php endif; ?>
	<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create expenses')): ?>
	<div class="col-md-6">
		<a href="<?php echo e(url('expenses/create')); ?>?summary_id=<?php echo e($summary->id); ?>" class="card">
			<div class="card-body">
				<h4>Expenses</h4>
				<h6><?php echo e(number_format($summary->summary_expenses_sum_amount)); ?></h6>
			</div>
		</a>
	</div>
	<?php endif; ?>
	<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create recoveries')): ?>
	<div class="col-md-6">
		<a href="<?php echo e(url('recoveries/create')); ?>?summary_id=<?php echo e($summary->id); ?>" class="card">
			<div class="card-body">
				<h4>Recoveries</h4>
				<h6><?php echo e(number_format($summary->recoveries_sum_amount)); ?></h6>
			</div>
		</a>
	</div>
	<?php endif; ?>
	<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create profits')): ?>
	<div class="col-md-6">
		<a href="<?php echo e(url('profits/create')); ?>?summary_id=<?php echo e($summary->id); ?>" class="card">
			<div class="card-body">
				<h4>Profits</h4>
				<h6><?php echo e(number_format($summary->profits_sum_amount)); ?></h6>
			</div>
		</a>
	</div>
	<?php endif; ?>
	<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('show summaries')): ?>
	<div class="col-md-6">
		<a href="<?php echo e(url('summaries/summary/'.$summary->id)); ?>" class="card">
			<div class="card-body">
				<h4>Summary</h4>
			</div>
		</a>
	</div>
	<?php endif; ?>
	<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete summaries')): ?>
		<div class="col-md-6">
			<form action="<?php echo e(route('summaries.destroy', compact('summary'))); ?>" method="POST" class="card m-0 p-0">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?>
                <button type="submit" class="card-body text-nowrap"><i class="fa fa-trash"></i> <?php echo app('translator')->get('Delete'); ?></button>
            </form>
		</div>
	<?php endif; ?>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/angus/public_html/warmth/resources/views/summaries/modules.blade.php ENDPATH**/ ?>