<?php $__env->startSection('suppliers.content'); ?>
<div class="container">
    <div class="card">
        <div class="card-header d-flex flex-column flex-md-row align-items-md-center justify-content-between">
            <h5 class="card-title">Suppliers</h5>

            <a href="<?php echo e(route('suppliers.create', [])); ?>" class="btn btn-primary"><i class="fa fa-plus"></i> <?php echo app('translator')->get('Create new Supplier'); ?></a>
        </div>
        <div class="card-body">
            <a href="<?php echo e(url('download_suppliers')); ?>" class="btn btn-primary">Download</a>
            <table class="table table-striped table-responsive table-hover dataTable">
                <thead role="rowgroup">
                    <tr role="row">
                        <th role='columnheader'>Name</th>
                        <th role='columnheader'>Contact</th>
                        <th role='columnheader'>Alt Contact</th>
                        <th role='columnheader'>Balance</th>
                        <th scope="col" data-label="Actions">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $suppliers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supplier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td data-label="Name"><?php echo e($supplier->name ?: "-"); ?></td>
                        <td data-label="Contact"><?php echo e($supplier->contact ?: "-"); ?></td>
                        <td data-label="Alt Contact"><?php echo e($supplier->alt_contact ?: "-"); ?></td>
                        <td data-label="Balance"><?php echo e($supplier->balance ?: "-"); ?></td>

                        <td data-label="Actions:" class="text-nowrap">
                         <?php if($supplier->trashed()): ?>
                         <form action="<?php echo e(route('suppliers.restore', ['supplier' => $supplier])); ?>" method="POST" class="d-inline-block me-2">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>
                            <input type="submit" name="restore" value="<?php echo app('translator')->get('Restore'); ?>" class="btn btn-success btn-sm"/>
                        </form>
                        <form action="<?php echo e(route('suppliers.purge', ['supplier' => $supplier])); ?>" method="POST" class="d-inline-block">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <input type="submit" name="purge" value="<?php echo app('translator')->get('Purge'); ?>" class="btn btn-danger btn-sm"/>
                        </form>
                        <?php else: ?>
                        <a href="<?php echo e(route('suppliers.show', compact('supplier'))); ?>" type="button" class="btn btn-primary btn-sm me-1"><?php echo app('translator')->get('Show'); ?></a>
                        <div class="btn-group btn-group-sm">
                            <button type="button" class="btn btn-light dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false"><i class="fa fa-cog"></i></button>
                            <ul class="dropdown-menu">
                                <li><a class="dropdown-item" href="<?php echo e(route('suppliers.edit', compact('supplier'))); ?>"><?php echo app('translator')->get('Edit'); ?></a></li>
                                <li>
                                    <form action="<?php echo e(route('suppliers.destroy', compact('supplier'))); ?>" method="POST" style="display: inline;" class="m-0 p-0">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="dropdown-item"><?php echo app('translator')->get('Delete'); ?></button>
                                    </form>
                                </li>
                            </ul>
                        </div>

                        <?php endif; ?>

                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
    <div class="text-center my-2">
        
    </div>
</div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('suppliers.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/angus/public_html/warmth/resources/views/suppliers/index.blade.php ENDPATH**/ ?>