<?php $__env->startSection('content'); ?>
<div class="card">
	<form class="card-body">
		<div class="row">
			<div class="col-md-4">
				<label>Date</label>
				<input type="date" class="form-control filter-input" name="date">
			</div>
			<div class="col-md-4">
				<label>Personel</label>
				<select class="select2 filter-input" name="personel_id">
					<option></option>
					<?php $__currentLoopData = $personels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $personel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					<option value="<?php echo e($personel['id']); ?>"><?php echo e($personel['name']); ?></option>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				</select>
			</div>

			<div class="col-md-4">
				<label>Branch</label>
				<select class="select2 filter-input" name="branch_id">
					<option></option>
					<?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					<option value="<?php echo e($branch->id); ?>"><?php echo e($branch->name); ?></option>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				</select>
				
			</div>
		</div>
	</form>
</div>
<div class="card">
	<div class="card-header">
		<h5 class="card-title">Collections</h5>
	</div>
	<div class="card-body">
		<div class="table-responsive">
			 <table class="table table-bordered" id="collections-table">
	        <thead>
	            <tr>
	                
	                <th>Date</th>
	                <th>Customer</th>
	                <th>Personel</th>
	                <th>Branch</th>
	                <th>Amount</th>
	                <th>Action</th>
	            </tr>
	        </thead>
	    </table>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('customjs'); ?>
<script type="text/javascript">
$(document).ready(function(){
	let table = $('#collections-table').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: "<?php echo e(route('collections.index')); ?>",
            data: function (d) {
                d.date = $('input[name=date]').val();
                d.personel_id = $('select[name=personel_id]').val();
                d.branch_id = $('select[name=branch_id]').val();
            }
        },
        columns: [
            // { data: 'id', name: 'id' },
            { data: 'date', name: 'date' },
            { data: 'customer_name', name: 'customer_name' },
            { data: 'personel_name', name: 'personel_name' },
            { data: 'branch_name', name: 'branch_name' },
            { data: 'amount', name: 'amount' },
            { data: 'action', name: 'action', orderable: false, searchable: false }
        ]
    });

    // // Reload DataTable on Filter Submit
    // $('#filter-form').on('submit', function (e) {
    //     e.preventDefault();
    //     table.draw();
    // });
    $('.filter-input').on('change', function () {
        table.ajax.reload();  // Correct way to reload without reinitializing
    });
})
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/angus/public_html/warmth/resources/views/collections/index.blade.php ENDPATH**/ ?>