<?php $__env->startSection('breadcrumb'); ?>
<div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
    <h4 class="mb-sm-0">Daily Summaries</h4>
    <div class="page-title-right">
        <ol class="breadcrumb m-0">
            <li class="breadcrumb-item"><a href="<?php echo e(url('dashboard')); ?>">Dashboard</a></li>
            <li class="breadcrumb-item"><a href="<?php echo e(url('summaries')); ?>">Daily Summaries</a></li>
            <li class="breadcrumb-item"><a href="javascript:void(0);"><?php echo e($summary->branch?->name); ?></a></li>
            <li class="breadcrumb-item"><a href="<?php echo e(url('summaries/modules/'.$summary->id)); ?>"><?php echo e(date('d M, Y',strtotime($summary->date))); ?></a></li>
            <li class="breadcrumb-item active">Intakes</li>
        </ol>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-header">
        <?php echo $__env->make('layouts.summaries_menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
    <div class="card-body">
        <form action="<?php echo e(url('intakes')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="summary_id" value="<?php echo e($summary->id); ?>">
            <div class="repeater">
                <table class="table">
                    <thead>
                        <th width="25%">Source</th>
                        <th width="25%">Inventory</th>
                        <th width="10%">Item Rate</th>
                        <th width="10%">Supplier Rate</th>
                        <th width="10%">Quantity</th>
                        <th width="10%">Total</th>
                        <th></th>
                    </thead>
                    <tbody data-repeater-list="items">
                        <tr data-repeater-item>
                            <td>
                                <select class="form-control form-select select2" name="source" required>
                                    <option></option>
                                    <?php $__currentLoopData = $sources; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $source): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($source['id']); ?>"><?php echo e($source['name']); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </td>
                            <td>
                                <select class="form-control form-select inventory-select select2" name="inventory_id" required>
                                    <option></option>
                                    <?php $__currentLoopData = $inventories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $inventory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option data-rate="<?php echo e($inventory->rate); ?>" value="<?php echo e($inventory->id); ?>"><?php echo e($inventory->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </td>
                            <td>
                                <input type="text" name="rate" class="form-control rate item_rate" required>
                            </td>
                            <td>
                                <input type="text" name="supplier_rate" class="form-control supplier_rate rate" required>
                            </td>
                            <td>
                                <input type="text" name="quantity" class="form-control quantity" required>
                            </td>
                            <td>
                                <input type="text" name="total" class="form-control total" disabled>
                            </td>
                            <td>
                                <button type="button" data-repeater-delete class="btn btn-danger">Delete</button>
                            </td>
                        </tr>
                    </tbody>
                </table>
                <button type="button" data-repeater-create class="btn btn-primary">Add</button>
            </div>
            <div class="mt-4">
                <div class="row">
                    <div class="col-md-3 offset-md-9">
                        <div class="form-group">
                            <label for="grand-total">Grand Total:</label>
                            <input type="text" id="grand-total" class="form-control" disabled>
                        </div>
                    </div>
                </div>
            </div>
            <div class="d-flex flex-row align-items-center justify-content-between">
                <a href="javascript:void(0);" class="btn btn-info">Back</a>
                <button type="submit" class="btn btn-success">Save</button>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('customjs'); ?>
<script type="text/javascript">
    $(document).ready(function () {
                $('.select2').select2()
        var $repeater = $('.repeater').repeater({
            initEmpty: true,
            show: function () {
                $(this).slideDown();
                $('.select2-container').remove();
                $('.select2').select2()
                bindEvents($(this));
            },
            hide: function (deleteElement) {
                $(this).slideUp(deleteElement, function() {
                    $(this).remove();
                    calculateGrandTotal();
                });
            }
        });

        <?php if(old('items')): ?>
            $repeater.setList(<?php echo json_encode(old('items'), 15, 512) ?>);
        <?php elseif(sizeOf($intakes) > 0): ?>
            $repeater.setList([
                <?php $__currentLoopData = $intakes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $intake): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    {
                        source: '<?php echo e($intake->id); ?>',
                        inventory_id: '<?php echo e($intake->inventory_id); ?>',
                        rate: '<?php echo e($intake->rate); ?>',
                        quantity: '<?php echo e($intake->quantity); ?>',
                        supplier_rate: '<?php echo e($intake->supplier_rate); ?>',
                        total: '<?php echo e($intake->amount); ?>',
                    },
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            ]);
        <?php endif; ?>

        calculateGrandTotal();

        // Bind the event functions to all initial repeater items
        $('.repeater [data-repeater-item]').each(function() {
            bindEvents($(this));
        });

        function bindEvents(item) {
            item.find('.inventory-select').on('change', function() {
                var selectedRate = $(this).find(':selected').data('rate') || 0;
                item.find('.rate').val(selectedRate).trigger('input');
            });

            item.find('.item_rate, .quantity').on('input', function() {
                var rate = parseFloat(item.find('.item_rate').val().replace(/,/g, '')) || 0;
                var quantity = parseFloat(item.find('.quantity').val()) || 0;
                var total = rate * quantity;
                item.find('.total').val(total.toLocaleString());
                calculateGrandTotal();
            });
        }

        function calculateGrandTotal() {
            var grandTotal = 0;
            $('.repeater .total').each(function() {
                var total = parseFloat($(this).val().replace(/,/g, '')) || 0;
                grandTotal += total;
            });
            $('#grand-total').val(grandTotal.toLocaleString());
        }
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/angus/public_html/warmth/resources/views/intakes/create.blade.php ENDPATH**/ ?>