<?php $__env->startSection('personels.content'); ?>
    <div class="container">
        <div class="card">
            <div class="card-header d-flex flex-column flex-md-row align-items-md-center justify-content-between">
                <ol class="breadcrumb m-0 p-0 flex-grow-1 mb-2 mb-md-0">
                    <li class="breadcrumb-item"><a href="<?php echo e(implode('/', ['','personels'])); ?>"> Personels</a></li>
                </ol>

                <form action="<?php echo e(route('personels.index', [])); ?>" method="GET" class="m-0 p-0">
                    <div class="input-group">
                        <input type="text" class="form-control form-control-sm me-2" name="search" placeholder="Search Personels..." value="<?php echo e(request()->search); ?>">
                        <span class="input-group-btn">
                            <button class="btn btn-info btn-sm" type="submit"><i class="fa fa-search"></i> <?php echo app('translator')->get('Go!'); ?></button>
                        </span>
                    </div>
                </form>
            </div>
            <div class="card-body">
                <table class="table table-striped table-responsive table-hover">
    <thead role="rowgroup">
    <tr role="row">
                    <th role='columnheader'>Name</th>
                    <th role='columnheader'>Station</th>
                    <th role='columnheader'>Status</th>
                <th scope="col" data-label="Actions">Actions</th>
    </tr>
    </thead>
    <tbody>
    <?php $__currentLoopData = $personels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $personel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
                            <td data-label="Name"><?php echo e($personel->name ?: "-"); ?></td>
                            <td data-label="Station"><?php echo e($personel->station ?: "-"); ?></td>
                            <td data-label="Status"><?php echo e($personel->status ?: "-"); ?></td>

            <td data-label="Actions:" class="text-nowrap">
                                   <?php if($personel->trashed()): ?>
    <form action="<?php echo e(route('personels.restore', ['personel' => $personel])); ?>" method="POST" class="d-inline-block me-2">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>
        <input type="submit" name="restore" value="<?php echo app('translator')->get('Restore'); ?>" class="btn btn-success btn-sm"/>
    </form>
    <form action="<?php echo e(route('personels.purge', ['personel' => $personel])); ?>" method="POST" class="d-inline-block">
        <?php echo csrf_field(); ?>
        <?php echo method_field('DELETE'); ?>
        <input type="submit" name="purge" value="<?php echo app('translator')->get('Purge'); ?>" class="btn btn-danger btn-sm"/>
    </form>
<?php else: ?>
    <a href="<?php echo e(route('personels.show', compact('personel'))); ?>" type="button" class="btn btn-primary btn-sm me-1"><?php echo app('translator')->get('Show'); ?></a>
<div class="btn-group btn-group-sm">
    <button type="button" class="btn btn-light dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false"><i class="fa fa-cog"></i></button>
    <ul class="dropdown-menu">
        <li><a class="dropdown-item" href="<?php echo e(route('personels.edit', compact('personel'))); ?>"><?php echo app('translator')->get('Edit'); ?></a></li>
        <li>
            <form action="<?php echo e(route('personels.destroy', compact('personel'))); ?>" method="POST" style="display: inline;" class="m-0 p-0">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?>
                <button type="submit" class="dropdown-item"><?php echo app('translator')->get('Delete'); ?></button>
            </form>
        </li>
    </ul>
</div>

<?php endif; ?>

                            </td>
        </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>

                <?php echo e($personels->withQueryString()->links()); ?>

            </div>
            <div class="text-center my-2">
                <a href="<?php echo e(route('personels.create', [])); ?>" class="btn btn-primary"><i class="fa fa-plus"></i> <?php echo app('translator')->get('Create new Personel'); ?></a>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('personels.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/angus/public_html/warmth/resources/views/personels/index.blade.php ENDPATH**/ ?>