<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Metrics Cards -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card bg-primary text-white">
                <div class="card-body">
                    <h5 class="text-white text-muted">Total Sales</h5>
                    <h2 class="text-white"><?php echo e(number_format($metrics['total_sales'], 2)); ?></h2>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-danger text-white">
                <div class="card-body">
                    <h5 class="text-white ">Total Expenses</h5>
                    <h2 class="text-white"><?php echo e(number_format($metrics['total_expenses'], 2)); ?></h2>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-success text-white">
                <div class="card-body">
                    <h5 class="text-white">Net Profit</h5>
                    <h2 class="text-white"><?php echo e(number_format($metrics['current_profit'], 2)); ?></h2>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-warning text-dark">
                <div class="card-body">
                    <h5 class="text-white">Customer Balances</h5>
                    <h2 class="text-white"><?php echo e(number_format($metrics['customer_balance'], 2)); ?></h2>
                </div>
            </div>
        </div>
    </div>

    <!-- Charts Section -->
    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">Sales Trend (Last 12 Months)</div>
                <div class="card-body">
                    <canvas id="salesTrendChart" height="120"></canvas>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card">
                <div class="card-header">Branch Performance</div>
                <div class="card-body">
                    <canvas id="branchPerformanceChart"></canvas>
                </div>
            </div>
        </div>
    </div>

    <!-- Interactive Data Grid -->
    <div class="row mt-4">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">Recent Transactions</div>
                <div class="card-body">
                    <livewire:recent-transactions-table />
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Chart.js and AlpineJS CDN -->
<script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.min.js"></script>
<script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Sales Trend Chart
    const salesCtx = document.getElementById('salesTrendChart').getContext('2d');
    new Chart(salesCtx, {
        type: 'line',
        data: {
            labels: <?php echo json_encode($salesTrend->map(function ($item) {
                return \Carbon\Carbon::create($item->year, $item->month)->format('M Y');
            })); ?>,
            datasets: [{
                label: 'Sales',
                data: <?php echo json_encode($salesTrend->pluck('total')); ?>,
                borderColor: '#4e73df',
                fill: false,
                tension: 0.4
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: { position: 'top' },
                tooltip: { mode: 'index', intersect: false }
            }
        }
    });

    // Branch Performance Chart
    const branchCtx = document.getElementById('branchPerformanceChart').getContext('2d');
    new Chart(branchCtx, {
        type: 'doughnut',
        data: {
            labels: <?php echo json_encode($branchPerformance->pluck('name')); ?>,
            datasets: [{
                data: <?php echo json_encode($branchPerformance->pluck('summaries_sum_total_sales')); ?>,
                backgroundColor: ['#4e73df', '#1cc88a', '#36b9cc', '#f6c23e'],
                hoverOffset: 20
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    position: 'right',
                    labels: { boxWidth: 15, padding: 20 }
                }
            }
        }
    });
});
</script>

<!-- Optional Alpine.js Filter Component -->
<div x-data="{ filterPeriod: '12m' }" class="row mt-4">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <div class="d-flex justify-content-between">
                    <span>Date Filter</span>
                    <select x-model="filterPeriod" class="form-select w-25">
                        <option value="7d">Last 7 Days</option>
                        <option value="30d">Last 30 Days</option>
                        <option value="12m">Last 12 Months</option>
                        <option value="custom">Custom Range</option>
                    </select>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/angus/public_html/warmth/resources/views/dashboard.blade.php ENDPATH**/ ?>