<?php $__env->startSection('inventories.content'); ?>
<div class="container">
    <div class="card">
        <div class="card-header d-flex flex-row align-items-center justify-content-between">
            <ol class="breadcrumb m-0 p-0">
                <li class="breadcrumb-item"><a href="<?php echo e(implode('/', ['','inventories'])); ?>"> Inventories</a></li>
                <li class="breadcrumb-item"><?php echo app('translator')->get('Create new'); ?></li>
            </ol>
        </div>

        <div class="card-body">
            <form action="<?php echo e(route('inventories.store', [])); ?>" method="POST" class="m-0 p-0">
                <div class="card-body">
                    <?php echo csrf_field(); ?>
                    <div class="mb-3">
                        <label for="name" class="form-label">Name:</label>
                        <input type="text" name="name" id="name" class="form-control" value="<?php echo e(@old('name')); ?>" required/>
                        <?php if($errors->has('name')): ?>
                        <div class='error small text-danger'><?php echo e($errors->first('name')); ?></div>
                        <?php endif; ?>
                    </div>
                    <div class="mb-3">
                        <label for="rate" class="form-label">Rate:</label>
                        <input type="text" name="rate" id="rate" class="form-control" value="<?php echo e(@old('rate')); ?>" required/>
                        <?php if($errors->has('rate')): ?>
                        <div class='error small text-danger'><?php echo e($errors->first('rate')); ?></div>
                        <?php endif; ?>
                    </div>

                </div>

                <div class="card-footer">
                    <div class="d-flex flex-row align-items-center justify-content-between">
                        <a href="<?php echo e(route('inventories.index', [])); ?>" class="btn btn-light"><?php echo app('translator')->get('Cancel'); ?></a>
                        <button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Create new Inventory'); ?></button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('inventories.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/angus/public_html/warmth/resources/views/inventories/create.blade.php ENDPATH**/ ?>