<?php $__env->startSection('content'); ?>
<div class="card">
    <h2 class="card-header">General Expenses</h2>
    <div class="card-body">
        <a href="<?php echo e(route('general_expenses.create')); ?>" class="btn btn-primary mb-3">Add Expense</a>
        <table class="table table-bordered dataTable">
            <thead>
                <tr>
                    <th>Date</th>
                    <th>Supplier</th>
                    <th>Item</th>
                    <th>Reference</th>
                    <th>Payment Method</th>
                    <th>Amount</th>
                    <th>Paid</th>
                    <th>Balance</th>
                    <th>Status</th>
                    
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $expenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $exp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e(date('d-M-Y',strtotime($exp->expense_date))); ?></td>
                    <td><?php echo e($exp->supplier?->name); ?></td>
                    <td><?php echo e($exp->expenseItem?->name); ?></td>
                    <td><?php echo e($exp->reference); ?></td>
                    <td><?php echo e($exp->payment_method?->name); ?></td>
                    <td><?php echo e(number_format($exp->amount,2)); ?></td>
                    <td><?php echo e(number_format($exp->paid_amount,2)); ?></td>
                    <td><?php echo e(number_format($exp->balance,2)); ?></td>
                    <td><?php echo e($exp->status); ?></td>
                    
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/angus/public_html/warmth/resources/views/general_expenses/index.blade.php ENDPATH**/ ?>