<?php $__env->startSection('content'); ?>
<div class="col-md-6 mx-auto">
	<form class="card" method="POST" action="<?php echo e(url('payments/'.$payment->id)); ?>" method="POST">
		<?php echo csrf_field(); ?>
		<?php echo method_field("PUT"); ?>
		<div class="card-header">
			<h5 class="card-title">Edit Payment</h5>
		</div>
		<div class="card-body">
			<div class="form-group mb-3" id="customer-section">
				<label>Customer</label>
				<select class="select2" name="customer_id" id="customer_id">
					<option value="" data-balance='0'></option>
					<?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					<option value="<?php echo e($customer->id); ?>" data-balance="<?php echo e(number_format($customer->balance)); ?>"><?php echo e($customer->name); ?></option>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				</select>
			</div>

			<div class="form-group mb-3" id="supplier-section">
				<label>Supplier</label>
				<select class="select2" name="supplier_id" id="supplier_id">
					<option value="" data-balance='0'></option>
					<?php $__currentLoopData = $suppliers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supplier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					<option value="<?php echo e($supplier->id); ?>" data-balance="<?php echo e(number_format($supplier->balance)); ?>"><?php echo e($supplier->name); ?></option>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				</select>
			</div>
			<div class="form-group mb-3">
				<label>Payment Method</label>
				<select class="select2" name="payment_method_id">
					<option value=""></option>
					<?php $__currentLoopData = $payment_methods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment_method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					<option value="<?php echo e($payment_method->id); ?>" <?php echo e((old('payment_method_id',$payment->payment_method_id) == $payment_method->id) ?'selected':''); ?>><?php echo e($payment_method->name); ?></option>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				</select>
			</div>
			<div class="form-group mb-3">
				<label>Balance</label>
				<input type="text" class="form-control" name="balance" id="balance" disabled>
			</div>
			<div class="form-group mb-3">
				<label>Reference</label>
				<input type="text" class="form-control" value="<?php echo e($payment->reference); ?>" name="reference" placeholder="Receipt No.">
			</div>
			<div class="form-group mb-3">
				<label>Amount Receipted</label>
				<input type="text" class="form-control" name="amount" id="amount" value="<?php echo e(number_format($payment->amount)); ?>">
			</div>
		</div>
		<div class="text-end card-footer">
			<button type="submit" class="btn btn-primary">Save Payment</button>
		</div>
	</form>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('customjs'); ?>
<script type="text/javascript">
	$(document).ready(function(){
		$('.select2').select2();

		var customer_id = <?php echo e($payment->customer_id ?? 'null'); ?>;
		var supplier_id = <?php echo e($payment->supplier_id ?? 'null'); ?>;

		if (customer_id) {
			$('#supplier-section').hide();
			$('#customer_id').val(customer_id).trigger('change');
		} else if (supplier_id) {
			$('#customer-section').hide();
			$('#supplier_id').val(supplier_id).trigger('change');
		}

		$('#customer_id').change(function(){
			var balance = $(this).find(':selected').data('balance');
			$('#balance').val(balance);
			if ($(this).val()) {
				$('#supplier-section').hide();
			} else {
				$('#supplier-section').show();
			}
		});

		$('#supplier_id').change(function(){
			var balance = $(this).find(':selected').data('balance');
			$('#balance').val(balance);
			if ($(this).val()) {
				$('#customer-section').hide();
			} else {
				$('#customer-section').show();
			}
		});

		$('#amount').on('input', function() {
			var value = $(this).val().replace(/,/g, '');
			if (!isNaN(value) && value.length > 0) {
				$(this).val(Number(value).toLocaleString('en'));
			} else {
				$(this).val('');
			}
		});
	});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/angus/public_html/warmth/resources/views/payments/edit.blade.php ENDPATH**/ ?>