@extends('layouts.app')
@section('breadcrumb')
<div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
	<h4 class="mb-sm-0">Users</h4>
	<div class="page-title-right">
		<ol class="breadcrumb m-0">
			<li class="breadcrumb-item"><a href="{{ url('dashboard') }}">Dashboard</a></li>
			<li class="breadcrumb-item active">Users</li>
		</ol>
	</div>
</div>
@endsection
@section('content')
<div class="card">
	<div class="card-header d-flex flex-row align-items-center justify-content-between">
		<h4>Users</h4>
		<a href="{{ url('users/create') }}" class="btn btn-primary">Add New User</a>
	</div>
	<div class="card-body">
		<div class="table-responsive">
			<table class="table dataTable">
				<thead>
					<th>Name</th>
					<th>Email</th>
					<th></th>
				</thead>
				<tbody>
					@foreach($users as $user)
						<tr>
							<td>{{ ucwords($user->name) }}</td>
							<td>{{ $user->email }}</td>
							<td>
								<a class="btn btn-primary btn-sm" href="{{ url('users/'.$user->id) }}">Show</a>
								<div class="btn-group btn-group-sm">
		                            <button type="button" class="btn btn-light dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false"><i class="fa fa-cog"></i></button>
		                            <ul class="dropdown-menu">
		                                <li><a class="dropdown-item" href="{{route('users.edit', compact('user'))}}">@lang('Edit')</a></li>
		                                <li>
		                                    <form action="{{route('users.destroy', compact('user'))}}" method="POST" style="display: inline;" class="m-0 p-0">
		                                        @csrf
		                                        @method('DELETE')
		                                        <button type="submit" class="dropdown-item">@lang('Delete')</button>
		                                    </form>
		                                </li>
		                            </ul>
		                        </div>
							</td>
						</tr>
					@endforeach
				</tbody>
			</table>
		</div>
	</div>
</div>
@endsection