@extends('layouts.app')
@section('content')
<div class="card">
	<form class="card-body">
		<div class="row">
			<div class="col-md-4">
				<label>Date</label>
				<input type="date" class="form-control" name="date">
			</div>
			<div class="col-md-4">
				<label>Inventory</label>
				<select class="select2" name="branch_id">
					<option></option>
					@foreach($inventories as $inventory)
					<option value="{{ $inventory->id }}">{{ $inventory->name }}</option>
					@endforeach
				</select>
			</div>

			<div class="col-md-4">
				<label>Source Destination</label>
				<select class="select2" name="source_branch_id">
					<option></option>
					@foreach($branches as $branch)
					<option value="{{ $branch->id }}">{{ $branch->name }}</option>
					@endforeach
				</select>
			</div>

			<div class="col-md-4">
				<label>Destination</label>
				<select class="select2" name="destination_branch_id">
					<option></option>
					@foreach($branches as $branch)
					<option value="{{ $branch->id }}">{{ $branch->name }}</option>
					@endforeach
				</select>
				<div class="text-end">
					<button type="submit" class="btn btn-success">Search</button>
				</div>
			</div>
		</div>
	</form>
</div>
<div class="card">
	<div class="card-header">
		<h5 class="card-title">Tranfers</h5>
	</div>
	<div class="card-body">
		<div class="table-responsive">
			<table class="table dataTable">
				<thead>
					<th>Date</th>
					<th>Source</th>
					<th>Destination</th>
					<th>Quantity</th>
					<th>Rate</th>
					<th>Amount</th>
				</thead>
				<tbody>
					@foreach($transfers as $transfer)
						<tr>
							<td>{{ date('d M, Y',strtotime($transfer->date)) }}</td>
							<td>{{ $transfer?->source?->name }}</td>
							<td>{{ $transfer?->destination?->name }}</td>
							<td>{{ $transfer->rate ? number_format($transfer->rate) : 0 }}</td>
							<td>{{ $transfer->quantity ? number_format($transfer->quantity) : 0 }}</td>
							<td>{{ $transfer->amount ? number_format($transfer->amount) : 0 }}</td>
						</tr>
					@endforeach
				</tbody>
			</table>
		</div>
	</div>
</div>
@endsection