@extends('layouts.app')
@section('breadcrumb')
<div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
    <h4 class="mb-sm-0">Daily Summaries</h4>
    <div class="page-title-right">
        <ol class="breadcrumb m-0">
            <li class="breadcrumb-item"><a href="{{ url('dashboard') }}">Dashboard</a></li>
            <li class="breadcrumb-item"><a href="{{ url('summaries') }}">Daily Summaries</a></li>
            <li class="breadcrumb-item"><a href="javascript:void(0);">{{ $summary->branch?->name }}</a></li>
            <li class="breadcrumb-item"><a href="{{ url('summaries/modules/'.$summary->id) }}">{{ date('d M, Y',strtotime($summary->date)) }}</a></li>
            <li class="breadcrumb-item active">Summarisation</li>
        </ol>
    </div>
</div>
@endsection
@section('content')
<div class="card">
	<div class="card-header">
		<h5>Day Summary</h5>
	</div>
	<div class="card-body">
		<h6 class="text-center fs-17">Summary</h6>
		<table class="table table-bordered border-secondary table-nowrap">
			<thead>
				<th>Opening Balance</th>
				<th>Added Stock</th>
				<th>Profits</th>
				<th>Gross Sales</th>
				<th>Tranfers</th>
				<th>Closing Balance</th>
			</thead>
			<tbody>
				<tr>
					<td>{{ number_format($summary->opening_balance,2) }}</td>
					<td>{{ number_format($summary->intake,2) }}</td>
					<td>{{ number_format($summary->profits_total) }}</td>
					<td>{{ number_format($summary->total_sales,2) }}</td>
					<td>{{ number_format($summary->transfers,2) }}</td>
					<td>{{ number_format($summary->closing_balance) }}</td>
				</tr>
			</tbody>
		</table>
		<h6 class="text-center fs-17">Collections</h6>
		<table class="table table-bordered border-secondary table-nowrap">
			<thead>
				<tr>
					<th scope="col">Personel</th>
					<th>Reason</th>
					<th scope="col">Amount</th>
				</tr>
			</thead>
			<tbody>
				@foreach($summary->collections as $collection)
					<tr>
						<td>{{ ($collection->personel_id) ? $collection->personel?->name :$collection->customer?->name  }}</td>
						<td>{{ $collection->reason }}</td>
						<td>{{ number_format($collection->amount,2) }}</td>
					</tr>
				@endforeach
				<tr class="">
					<td colspan="2" class="text-end fw-22">Total</td>
					<td>{{ number_format($summary->cash_sales,2) }}</td>
				</tr>
			</tbody>
		</table>
		<h6 class="text-center fs-17">Credits</h6>
		<table class="table table-bordered border-secondary table-nowrap">
			<thead>
				<tr>
					<th scope="col">Customer</th>
					<th>Receipt No.</th>
					<th scope="col">Amount</th>
				</tr>
			</thead>
			<tbody>
				@foreach($summary->credits as $credit)
					<tr>
						<td>{{ $credit->customer?->name }}</td>
						<td>{{ $credit->receipt_no }}</td>
						<td>{{ number_format($credit->amount,2) }}</td>
					</tr>
				@endforeach
				<tr>
					<td colspan="2" class="text-end">Total</td>
					<td>{{ number_format($summary->credit_sales,2) }}</td>
				</tr>
			</tbody>
		</table>
		<h6 class="text-center fs-17">Discounts</h6>
		<table class="table table-bordered border-secondary table-nowrap">
			<thead>
				<tr>
					<th scope="col">Customer</th>
					<th scope="col">Inventory</th>
					<th scope="col">Rate</th>
					<th scope="col">Quantity</th>
					<th scope="col">Amount</th>
				</tr>
			</thead>
			<tbody>
				@foreach($summary->summary_discounts as $discount)
					<tr>
						<td>{{ $discount->customer?->name }}</td>
						<td>{{ $discount->inventory?->name }}</td>
						<td>{{ number_format($discount->discount_rate) }}</td>
						<td>{{ number_format($discount->quantity) }}</td>
						<td>{{ number_format($discount->total_discount,2) }}</td>
					</tr>
				@endforeach
				<tr>
					<td colspan="4" class="text-end">Total</td>
					<td>{{ number_format($summary->discounts,2) }}</td>
				</tr>
			</tbody>
		</table>
		<h6 class="text-center fs-17">Intakes</h6>
		<table class="table table-bordered border-secondary table-nowrap">
			<thead>
				<tr>
					<th scope="col">Source</th>
					<th scope="col">Inventory</th>
					<th scope="col">Rate</th>
					<th scope="col">Quantity</th>
					<th scope="col">Amount</th>
				</tr>
			</thead>
			<tbody>
				@foreach($summary->intakes as $intake)
					<tr>
						<td>{{ ($intake->supplier_id) ? $intake->supplier?->name : $intake->branch?->name }}</td>
						<td>{{ $intake->inventory?->name }}</td>
						<td>{{ number_format($intake->rate) }}</td>
						<td>{{ number_format($intake->quantity) }}</td>
						<td>{{ number_format($intake->amount,2) }}</td>
					</tr>
				@endforeach
				<tr>
					<td colspan="4" class="text-end">Total</td>
					<td>{{ number_format($summary->intake,2) }}</td>
				</tr>
			</tbody>
		</table>
		<h6 class="text-center fs-17">Transfers</h6>
		<table class="table table-bordered border-secondary table-nowrap">
			<thead>
				<tr>
					<th scope="col">Destination</th>
					<th scope="col">Inventory</th>
					<th scope="col">Rate</th>
					<th scope="col">Quantity</th>
					<th scope="col">Amount</th>
				</tr>
			</thead>
			<tbody>
				@foreach($summary->summary_transfers as $transfer)
					<tr>
						<td>{{ $transfer->destination?->name }}</td>
						<td>{{ $transfer->inventory?->name }}</td>
						<td>{{ number_format($transfer->rate) }}</td>
						<td>{{ number_format($transfer->quantity) }}</td>
						<td>{{ number_format($transfer->amount,2) }}</td>
					</tr>
				@endforeach
				<tr>
					<td colspan="4" class="text-end">Total</td>
					<td>{{ number_format($summary->transfers,2) }}</td>
				</tr>
			</tbody>
		</table>
		<h6 class="text-center fs-17">Recoveries</h6>
		<table class="table table-bordered border-secondary table-nowrap">
			<thead>
				<tr>
					<th scope="col">Personel</th>
					<th scope="col">Customer</th>
					<th>Amount</th>
				</tr>
			</thead>
			<tbody>
				@foreach($summary->recoveries as $recovery)
					<tr>
						<td>{{ $recovery->personel?->name }}</td>
						<td>{{ $recovery->customer?->name }}</td>
						<td>{{ number_format($recovery->amount,2) }}</td>
					</tr>
				@endforeach
				<tr>
					<td class="text-end">Total</td>
					<td></td>
					<td>{{ number_format($summary->total_recoveries,2) }}</td>
				</tr>
			</tbody>
		</table>
		<h6 class="text-center fs-17">Expenses</h6>
		<table class="table table-bordered border-secondary table-nowrap">
			<thead>
				<tr>
					<th scope="col">Item</th>
					<th scope="col">Amount</th>
				</tr>
			</thead>
			<tbody>
				@foreach($summary->summary_expenses as $expense)
					<tr>
						<td>{{ $expense->expense_item?->name }}</td>
						<td>{{ number_format($expense->amount,2) }}</td>
					</tr>
				@endforeach
				<tr>
					<td class="text-end">Total</td>
					<td>{{ number_format($summary->expenses,2) }}</td>
				</tr>
			</tbody>
		</table>
	</div>
</div>
@endsection