@extends('layouts.app')
@section('content')
<div class="row">
	<form class="card col-md-6 mx-auto" action="{{ url('summaries') }}" method="POST">
		@csrf
		<div class="card-header d-flex flex-row align-items-center">
			<h5>Branch Selection</h5>
		</div>
		<div class="card-body">
			<div class="form-group mb-3">
				<label>Date</label>
				<input type="date" name="date" class="form-control" value="{{ @old('date') }}" required>
			</div>
			<div class="form-group mb-3">
				<label>Branch</label>
				<select class="form-select form-control select2" name="branch_id" required>
					<option value="" selected disabled></option>
					@foreach($branches as $branch)
					<option value="{{ $branch->id }}" {{ @old('branch_id') == $branch->id ?'selected':'' }}>{{ $branch->name }}</option>
					@endforeach
				</select>
			</div>
			<div class="form-group">
				<label>Personel</label>
				<select class="form-select form-control select2" name="personel_id" required>
					<option value="" selected disabled></option>
					@foreach($personels as $personel)
					<option value="{{ $personel->id }}" {{ @old('personel_id') == $personel->id ?'selected':'' }}>{{ $personel->name }}</option>
					@endforeach
				</select>
			</div>
		</div>
		<div class="card-footer d-flex flex-row align-items-center justify-content-between">
			<a href="{{ url('summaries') }}" class="btn btn-info">Back</a>
			<button type="submit" class="btn btn-primary">Start Summarisation</button>
		</div>
	</form>
</div>
@endsection