@extends('layouts.app')
@section('content')
<div class="col-md-6 mx-auto">
	<form class="card" method="POST" action="{{ url('payments') }}">
		@csrf
		<div class="card-header">
			<h5 class="card-title">Add Payment</h5>
		</div>
		<div class="card-body">
			<div class="form-group mb-3" id="customer-section">
				<label>Customer</label>
				<select class="select2" name="customer_id" id="customer_id">
					<option value="" data-balance='0'></option>
					@foreach($customers as $customer)
					<option value="{{ $customer->id }}" data-balance="{{ number_format($customer->balance) }}">{{ $customer->name }}</option>
					@endforeach
				</select>
			</div>

			<div class="form-group mb-3" id="supplier-section">
				<label>Supplier</label>
				<select class="select2" name="supplier_id" id="supplier_id">
					<option value="" data-balance='0'></option>
					@foreach($suppliers as $supplier)
					<option value="{{ $supplier->id }}" data-balance="{{ number_format($supplier->balance) }}">{{ $supplier->name }}</option>
					@endforeach
				</select>
			</div>
			<div class="form-group mb-3">
				<label>Payment Method</label>
				<select class="select2" name="payment_method_id">
					<option value=""></option>
					@foreach($payment_methods as $payment_method)
					<option value="{{ $payment_method->id }}" {{ (old('payment_method_id') == $payment_method->id) ? 'selected' : '' }}>{{ $payment_method->name }}</option>
					@endforeach
				</select>
			</div>
			<div class="form-group mb-3">
				<label>Payment Date</label>
				<input type="date" class="form-control" name="date" id="date" required>
			</div>
			<div class="form-group mb-3">
				<label>Balance</label>
				<input type="text" class="form-control" name="balance" id="balance" disabled>
			</div>
			<div class="form-group mb-3">
				<label>Reference</label>
				<input type="text" class="form-control" name="reference" placeholder="Receipt No.">
			</div>
			<div class="form-group mb-3">
				<label>Amount Receipted</label>
				<input type="text" class="form-control" name="amount" id="amount">
			</div>
		</div>
		<div class="text-end card-footer">
			<button type="submit" class="btn btn-primary">Save Payment</button>
		</div>
	</form>
</div>
@endsection
@section('customjs')
<script type="text/javascript">
	$(document).ready(function(){
		$('.select2').select2();

		var customer_id = {{ $customer_id ?? 'null' }};
		var supplier_id = {{ $supplier_id ?? 'null' }};

		if (customer_id) {
			$('#supplier-section').hide();
			$('#customer_id').val(customer_id).trigger('change');
		} else if (supplier_id) {
			$('#customer-section').hide();
			$('#supplier_id').val(supplier_id).trigger('change');
		}

		$('#customer_id').change(function(){
			var balance = $(this).find(':selected').data('balance');
			$('#balance').val(balance);
			if ($(this).val()) {
				$('#supplier-section').hide();
			} else {
				$('#supplier-section').show();
			}
		});

		$('#supplier_id').change(function(){
			var balance = $(this).find(':selected').data('balance');
			$('#balance').val(balance);
			if ($(this).val()) {
				$('#customer-section').hide();
			} else {
				$('#customer-section').show();
			}
		});

		$('#amount').on('input', function() {
			var value = $(this).val().replace(/,/g, '');
			if (!isNaN(value) && value.length > 0) {
				$(this).val(Number(value).toLocaleString('en'));
			} else {
				$(this).val('');
			}
		});
	});
</script>
@endsection
