@extends('inventories.layout')

@section('inventories.content')
<div class="container">
    <div class="card">
        <div class="card-header d-flex flex-column flex-md-row align-items-md-center justify-content-between">
            <h5>Inventories</h5>

            <a href="{{ route('inventories.create', []) }}" class="btn btn-primary"><i class="fa fa-plus"></i> @lang('Create new Inventory')</a>
        </div>
        <div class="card-body">
            <table class="table table-striped table-responsive table-hover dataTable">
                <thead role="rowgroup">
                    <tr role="row">
                        <th role='columnheader'>Name</th>
                        <th role='columnheader'>Rate</th>
                        <th scope="col" data-label="Actions">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($inventories as $inventory)
                    <tr>
                        <td data-label="Name">{{ $inventory->name ?: "-" }}</td>
                        <td data-label="Rate">{{ $inventory->rate ? number_format($inventory->rate) : "-" }}</td>

                        <td data-label="Actions:" class="text-nowrap">
                         @if($inventory->trashed())
                         <form action="{{ route('inventories.restore', ['inventory' => $inventory]) }}" method="POST" class="d-inline-block me-2">
                            @csrf
                            @method('PUT')
                            <input type="submit" name="restore" value="@lang('Restore')" class="btn btn-success btn-sm"/>
                        </form>
                        <form action="{{ route('inventories.purge', ['inventory' => $inventory]) }}" method="POST" class="d-inline-block">
                            @csrf
                            @method('DELETE')
                            <input type="submit" name="purge" value="@lang('Purge')" class="btn btn-danger btn-sm"/>
                        </form>
                        @else
                        <a href="{{route('inventories.show', compact('inventory'))}}" type="button" class="btn btn-primary btn-sm me-1">@lang('Show')</a>
                        <div class="btn-group btn-group-sm">
                            <button type="button" class="btn btn-light dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false"><i class="fa fa-cog"></i></button>
                            <ul class="dropdown-menu">
                                <li><a class="dropdown-item" href="{{route('inventories.edit', compact('inventory'))}}">@lang('Edit')</a></li>
                                <li>
                                    <form action="{{route('inventories.destroy', compact('inventory'))}}" method="POST" style="display: inline;" class="m-0 p-0">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="dropdown-item">@lang('Delete')</button>
                                    </form>
                                </li>
                            </ul>
                        </div>

                        @endif

                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
    <div class="text-center my-2">
        
    </div>
</div>
</div>
@endsection
