@extends('layouts.app')
@section('content')
<div class="card">
	<form class="card-body">
		<div class="row">
			<div class="col-md-4">
				<label>Date</label>
				<input type="date" class="form-control" name="date">
			</div>
			<div class="col-md-4">
				<label>Inventory</label>
				<select class="select2" name="inventory_id">
					<option></option>
					@foreach($inventories as $inventory)
					<option value="{{ $inventory->id }}">{{ $inventory->name }}</option>
					@endforeach
				</select>
			</div>

			<div class="col-md-4">
				<label>Supplier</label>
				<select class="select2" name="supplier_id">
					<option></option>
					@foreach($sources as $source)
					<option value="{{ $source['id'] }}">{{ $source['name'] }}</option>
					@endforeach
				</select>
			</div>

			<div class="col-md-4">
				<label>Branch</label>
				<select class="select2" name="branch_id">
					<option></option>
					@foreach($branches as $branch)
					<option value="{{ $branch->id }}">{{ $branch->name }}</option>
					@endforeach
				</select>
				<div class="text-end">
					<button type="submit" class="btn btn-success">Search</button>
				</div>
			</div>
		</div>
	</form>
</div>
<div class="card">
	<div class="card-header">
		<h5 class="card-title">Intakes</h5>
	</div>
	<div class="card-body">
		<div class="table-responsive">
			<table class="table dataTable">
				<thead>
					<th>Date</th>
					<th>Branch</th>
					<th>Source</th>
					<th>Inventory</th>
					<th>Rate</th>
					<th>Quantity</th>
					<th>Amount</th>
				</thead>
				<tbody>
					@foreach($intakes as $intake)
						<tr>
							<td>{{ date('d M, Y',strtotime($intake->date)) }}</td>
							<td>{{ $intake?->summary?->branch?->name }}</td>
							<td>{{ $intake->supplier_id ? $intake->supplier?->name : $intake->branch?->name }}</td>
							<td>
								{{ $intake->inventory?->name }}
							</td>
							<td>{{ $intake->rate ? number_format($intake->rate) : 0}}</td>
							<td>{{ $intake->quantity ? number_format($intake->quantity) : 0}}</td>
							<th>{{ $intake->amount ? number_format($intake->amount) : 0}}</th>
						</tr>
					@endforeach
				</tbody>
			</table>
		</div>
	</div>
</div>
@endsection