@extends('layouts.app')

@section('content')
<div class="card">
    <h2 class="card-header">General Expenses</h2>
    <div class="card-body">
        <a href="{{ route('general_expenses.create') }}" class="btn btn-primary mb-3">Add Expense</a>
        <table class="table table-bordered dataTable">
            <thead>
                <tr>
                    <th>Date</th>
                    <th>Supplier</th>
                    <th>Item</th>
                    <th>Reference</th>
                    <th>Payment Method</th>
                    <th>Amount</th>
                    <th>Paid</th>
                    <th>Balance</th>
                    <th>Status</th>
                    {{-- <th>Actions</th> --}}
                </tr>
            </thead>
            <tbody>
                @foreach ($expenses as $exp)
                <tr>
                    <td>{{ date('d-M-Y',strtotime($exp->expense_date)) }}</td>
                    <td>{{ $exp->supplier?->name }}</td>
                    <td>{{ $exp->expenseItem?->name }}</td>
                    <td>{{ $exp->reference }}</td>
                    <td>{{ $exp->payment_method?->name }}</td>
                    <td>{{ number_format($exp->amount,2) }}</td>
                    <td>{{ number_format($exp->paid_amount,2) }}</td>
                    <td>{{ number_format($exp->balance,2) }}</td>
                    <td>{{ $exp->status }}</td>
                    {{--<td>
                         <a href="{{ route('general_expenses.edit', $exp->id) }}" class="btn btn-warning btn-sm">Edit</a>
                        <form action="{{ route('general_expenses.destroy', $exp->id) }}" method="POST" style="display:inline;">
                            @csrf @method('DELETE')
                            <button class="btn btn-danger btn-sm" onclick="return confirm('Delete this expense?')">Delete</button>
                        </form> 
                    </td>--}}
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
@endsection
