<div class="row">
    <div class="mb-3 col-md-6">
        <label>Expense Date</label>
        <input type="date" name="expense_date" class="form-control" value="{{ old('expense_date', $general_expense->expense_date ?? '') }}" required>
    </div>
    <div class="mb-3 col-md-6">
        <label>Reference</label>
        <input type="text" name="reference" class="form-control" value="{{ old('reference', $general_expense->reference ?? '') }}">
    </div>
    <div class="mb-3 col-md-6">
        <label>Supplier</label>
        <select name="supplier_id" class="form-control select2" required>
            <option></option>
            @foreach($suppliers as $supplier)
            <option value="{{ $supplier->id }}" {{ old('supplier_id', $general_expense->supplier_id ?? '') == $supplier->id ? 'selected' : '' }}>{{ $supplier->name }}</option>
            @endforeach
        </select>
    </div>
    <div class="mb-3 col-md-6">
        <label>Expense Item</label>
        <select name="expense_item_id" class="form-control select2" required>
            <option></option>
            @foreach($items as $item)
            <option value="{{ $item->id }}" {{ old('expense_item_id', $general_expense->expense_item_id ?? '') == $item->id ? 'selected' : '' }}>{{ $item->name }}</option>
            @endforeach
        </select>
    </div>
    <div class="mb-3 col-md-6">
        <label>Payment Method</label>
        <select name="payment_method_id" class="form-control" required>
            <option></option>
            @foreach($methods as $method)
            <option value="{{ $method->id }}" {{ old('payment_method_id', $general_expense->payment_method_id ?? '') == $method->id ? 'selected' : '' }}>{{ $method->name }}</option>
            @endforeach
        </select>
    </div>
    <div class="mb-3 col-md-6">
        <label>Amount</label>
        <input type="text" name="amount" class="form-control" value="{{ old('amount', $general_expense->amount ?? '') }}" required>
    </div>
    {{-- <div class="mb-3">
        <label>Paid Amount</label>
        <input type="text" name="paid_amount" class="form-control" value="{{ old('paid_amount', $general_expense->paid_amount ?? '') }}">
    </div> --}}
    <div class="mb-3">
        <label>Narration</label>
        {{-- <input type="text" name="narration" class="form-control" value="{{ old('narration', $general_expense->narration ?? '') }}"> --}}
        <textarea name="narration" class="form-control">{{ old('narration', $general_expense->narration ?? '') }}</textarea>
    </div>
</div>
{{-- <div class="mb-3">
    <label>Status</label>
    <input type="text" name="status" class="form-control" value="{{ old('status', $general_expense->status ?? '') }}">
</div> --}}
