@extends('layouts.app')

@section('content')
<div class="card">
    <div class="card-header d-flex flex-column flex-md-row align-items-md-center justify-content-between">
        <h5>Disbursements</h5>
        <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#disbursementModal">
            New Disbursement
        </button>
    </div>
    <div class="card-body">
        <div class="row mb-3">
            <div class="col-md-4">
                <label>Date</label>
                <input type="date" class="form-control" id="filter-date">
            </div>
            <div class="col-md-4">
                <label>Personnels</label>
                <select class="form-control select2" id="filter-customer">
                    <option value="">All Personnels</option>
                    @foreach($personels as $customer)
                        <option value="{{ $customer->id }}">{{ $customer->name }}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-4">
                <label>Suppliers</label>
                <select class="form-control select2" id="filter-branch">
                    <option value="">All Suppliers</option>
                    @foreach($suppliers as $branch)
                        <option value="{{ $branch->id }}">{{ $branch->name }}</option>
                    @endforeach
                </select>
            </div>
        </div>

        <table class="table table-bordered" id="credits-table">
            <thead>
                <tr>
                    <th></th> <!-- Expand/Collapse Icon Column -->
                    <th>Count</th>
                    <th>Date</th>
                    <th>Personnel</th>
                    <th>Supplier</th>
                    <th>Amount</th>
                    <th>Balance</th>
                    <th>Actions</th>
                </tr>
            </thead>
        </table>
    </div>
</div>

<!-- Disbursement Date Modal -->
<div class="modal fade" id="disbursementModal" tabindex="-1" aria-labelledby="disbursementModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="disbursementModalLabel">Select Disbursement Date</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <label for="disbursement-date" class="form-label">Disbursement Date</label>
                <input type="date" class="form-control" id="disbursement-date" required>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" id="proceed-disbursement" class="btn btn-primary">Proceed</button>
            </div>
        </div>
    </div>
</div>
@endsection
@section('customjs')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
<script>
$(document).ready(function() {
    // Initialize Select2 for dropdowns
    $('.select2').select2();

    // Initialize DataTable with expandable rows
    let table = $('#credits-table').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: "{{ route('disbursements.index') }}",
            data: function(d) {
                d.date = $('#filter-date').val();
                d.personel_id = $('#filter-customer').val();
                d.supplier_id = $('#filter-branch').val();
            }
        },
        columns: [
            { 
                className: 'dt-control',
                orderable: false,
                data: null,
                defaultContent: '',
            },
            { data: 'orderNo', name: 'orderNo' },
            { data: 'date', name: 'date' },
            { data: 'personel', name: 'personel' },
            { data: 'supplier', name: 'supplier' },
            { data: 'amount', name: 'amount' },
            { data: 'balance', name: 'balance' },
            { data: 'action', name: 'action' }
        ]
    });

    // Reload table when filters change
    $('#filter-date, #filter-customer, #filter-branch').change(function() {
        table.ajax.reload();
    });

    // Handle disbursement modal "Proceed" button click
    $('#proceed-disbursement').on('click', function() {
        const disbursementDate = $('#disbursement-date').val();

        if (disbursementDate) {
            window.location.href = `{{ url('disbursements/create') }}?date=${disbursementDate}`;
        } else {
            alert('Please select a disbursement date.');
        }
    });

    // Expand/Collapse row to show "Reason"
    $('#credits-table tbody').on('click', 'td.dt-control', function () {
        var tr = $(this).closest('tr');
        var row = table.row(tr);

        if (row.child.isShown()) {
            row.child.hide();
            $(this).find('i').removeClass('fa-minus-circle').addClass('fa-plus-circle');
        } else {
            row.child(format(row.data())).show();
            $(this).find('i').removeClass('fa-plus-circle').addClass('fa-minus-circle');
        }
    });

    // Function to display "Reason" in the expanded row
    function format(data) {
        return `
            <table class="table table-sm table-bordered">
                <tr>
                    <th>Reason:</th>
                    <td>${data.reason || 'No reason provided'}</td>
                </tr>
            </table>
        `;
    }
});
</script>
@endsection
