@extends('layouts.app')
@section('content')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<div class="col-md-6 mx-auto">
    <form class="">
    	@if(isset($customers))
        <select class="select2" name="customer_id" id="customer_id">
            <option value="">Select Customer</option>
            @foreach($customers as $customer)
            <option value="{{ $customer->id }}" {{ ($customer_id == $customer->id)?'selected':'' }}>{{ $customer->name }}</option>
            @endforeach
        </select>
        @endif
        @if(isset($suppliers))
        <select class="select2" name="supplier_id" id="supplier_id" style="margin-top: 10px;">
            <option value="">Select Supplier</option>
            @foreach($suppliers as $supplier)
            <option value="{{ $supplier->id }}" {{ ($supplier_id == $supplier->id)?'selected':'' }}>{{ $supplier->name }}</option>
            @endforeach
        </select>
        @endif
        <button type="submit" class="btn btn-primary" style="margin-top: 10px;">Get Ledger {{ ($entries) ? ' ('.$entries->count().')' : '' }}</button>

        <button class="btn btn-info" name="export" value="pdf" style="margin-top: 10px;">Export</button>

        @if(isset($customer_id))
            <a href="{{ url('clean_ledger/?customer_id='.$customer_id) }}" class="btn btn-danger" style="margin-top: 10px;">Clean Customer Ledger</a>
        @elseif(isset($supplier_id))
            <a href="{{ url('clean_ledger/?supplier_id='.$supplier_id) }}" class="btn btn-danger" style="margin-top: 10px;">Clean Supplier Ledger</a>
        @endif
    </form>
</div>
<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Label</th>
                        <th>Module</th>
                        <th>Credit</th>
                        <th>Debit</th>
                        <th>Balance</th>
                        <th>Status</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    @if($entries)
                        @foreach($entries as $entry)
                            <tr class="{{ $entry->deletable ? 'table-danger' : '' }}">
                                <td>{{ date('d M, Y', strtotime($entry->date)) }}</td>
                                <td>{{ $entry->label }}</td>
                                <td>{{ $entry->module }}</td>
                                <td>{{ $entry->credit ? number_format($entry->credit) : '-' }}</td>
                                <td>{{ $entry->debit ? number_format($entry->debit) : '-' }}</td>
                                <td>{{ $entry->balance ? number_format($entry->balance) : '-' }}</td>
                                <td>{{ $entry->status }}</td>
                                <td>
                                    @if($entry->deletable)
                                        <form action="{{ route('delete_ledger', $entry->id) }}" method="POST" id="delete-form-{{ $entry->id }}" style="display: inline;">
                                            @csrf
                                            @method('DELETE')
                                            <button type="button" class="btn btn-danger btn-sm delete-button" data-id="{{ $entry->id }}" data-label="{{ $entry->label }}">
                                                Delete
                                            </button>
                                        </form>
                                    @endif
                                </td>
                            </tr>
                        @endforeach
                    @endif
                </tbody>
            </table>
        </div>
    </div>
</div>
<script>
    document.addEventListener("DOMContentLoaded", function () {
        // Add click event listeners to delete buttons
        document.querySelectorAll('.delete-button').forEach(button => {
            button.addEventListener('click', function () {
                const entryId = this.dataset.id;
                const entryLabel = this.dataset.label;

                // Show confirmation dialog
                Swal.fire({
                    title: 'Are you sure?',
                    text: `You are about to delete "${entryLabel}". "${entryId}" This action cannot be undone.`,
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'Delete',
                    cancelButtonText: 'Cancel',
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#3085d6',
                    reverseButtons: true // Ensures positive button is on the right
                }).then((result) => {
                    if (result.isConfirmed) {
                        // Submit the form if confirmed
                        document.getElementById(`delete-form-${entryId}`).submit();
                    }
                });
            });
        });

        // Ensure only one select is filled
        document.getElementById('customer_id').addEventListener('change', function() {
            if (this.value) {
                document.getElementById('supplier_id').value = '';
            }
        });
        document.getElementById('supplier_id').addEventListener('change', function() {
            if (this.value) {
                document.getElementById('customer_id').value = '';
            }
        });
    });
</script>
@endsection