@extends('layouts.app')
@section('content')
<div class="card">
    <div class="card-header">
        <h4>Credits</h4>
    </div>
    <div class="card-body">
        <div class="row mb-3">
            <div class="col-md-4">
                <label>Date</label>
                <input type="date" class="form-control" id="filter-date">
            </div>
            <div class="col-md-4">
                <label>Customer</label>
                <select class="form-control select2" id="filter-customer">
                    <option value="">All Customers</option>
                    @foreach($customers as $customer)
                        <option value="{{ $customer->id }}">{{ $customer->name }}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-4">
                <label>Branch</label>
                <select class="form-control select2" id="filter-branch">
                    <option value="">All Branches</option>
                    @foreach($branches as $branch)
                        <option value="{{ $branch->id }}">{{ $branch->name }}</option>
                    @endforeach
                </select>
            </div>
        </div>

        <table class="table table-bordered" id="credits-table">
            <thead>
                <tr>
                    {{-- <th>ID</th> --}}
                    <th>Date</th>
                    <th>Customer</th>
                    <th>Branch</th>
                    <th>Amount</th>
                    <th>Actions</th>
                </tr>
            </thead>
        </table>
    </div>
</div>
@endsection

@section('customjs')
<script>
$(document).ready(function() {
    // Initialize Select2 for dropdowns
    $('.select2').select2();

    // Initialize DataTable with server-side processing
    let table = $('#credits-table').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: "{{ route('credits.index') }}",
            data: function(d) {
                d.date = $('#filter-date').val();
                d.customer_id = $('#filter-customer').val();
                d.branch_id = $('#filter-branch').val();
            }
        },
        columns: [
            // { data: 'id', name: 'id' },
            { data: 'date', name: 'date' },
            { data: 'customer_name', name: 'customer_name' },
            { data: 'branch_name', name: 'branch_name' },
            { data: 'amount', name: 'amount' },
            { data: 'action', name: 'action' }
        ]
    });

    // Automatically reload the table when filters change
    $('#filter-date, #filter-customer, #filter-branch').change(function() {
        table.ajax.reload();
    });
});
</script>
@endsection
