@extends('layouts.app')
@section('content')
<form class="card col-md-8 mx-auto" action="{{ url('credits/'.$credit->id) }}" method="POST">
	@method("PUT")
	@csrf
	<div class="card-body">
		<div class="form-group mb-3">
			<label>Customer</label>
			<select class="select2" name="customer_id">
				@foreach($customers as $customer)
				<option value="{{ $customer->id }}" {{ (($customer->id == $credit->customer_id) ? 'selected':'') }}>{{ $customer->name }}</option>
				@endforeach
			</select>
		</div>
		<div class="form-group">
			<label>Receipt No.</label>
			<input type="text" class="form-control" name="receipt_no" value="{{ $credit->receipt_no }}">
		</div>
		<div class="form-group">
			<label>Amount</label>
			<input type="text" class="form-control" name="amount" value="{{ $credit->amount }}">
		</div>
	</div>
	<div class="card-footer text-end">
		<button type="submit" class="btn btn-primary">Update</button>
	</div>
</form>
@endsection
@section('customjs')
<script type="text/javascript">
	$(document).ready(function(){
        // $('.select2').select2();
	})
</script>
@endsection