@extends('layouts.app')
@section('content')
<form class="card col-md-8 mx-auto" action="{{ url('collections/'.$collection->id) }}" method="POST">
	@method("PUT")
	@csrf
	<div class="card-body">
		<div class="form-group mb-3">
			<label>Customer</label>
			<select class="select2" name="customer_id">
				@foreach($personels as $personel)
				<option 
                        value="{{ $personel['id'] }}" 
                        @if($personel['id'] == (isset($collection->customer_id) ? 'C'.$collection->customer_id : 'P'.$collection->personel_id)) 
                            selected 
                        @endif
                    >
                        {{ $personel['name'] }}
                    </option>
				@endforeach
			</select>
		</div>
		<div class="form-group">
			<label>Reason</label>
			<input type="text" class="form-control" name="reason" value="{{ $collection->reason }}">
		</div>
		<div class="form-group">
			<label>Amount</label>
			<input type="text" class="form-control" name="amount" value="{{ $collection->amount }}">
		</div>
	</div>
	<div class="card-footer text-end">
		<button type="submit" class="btn btn-primary">Update</button>
	</div>
</form>
@endsection
@section('customjs')
<script type="text/javascript">
	$(document).ready(function(){
        // $('.select2').select2();
	})
</script>
@endsection