@extends('layouts.app')

@section('content')
<div class="card">
    <div class="card-header">
        <h5>{{ __("Approval Requests Summary") }}</h5>
        <form action="{{ route('approvals.summary') }}" method="GET" class="mt-2">
            <div class="input-group">
                <input type="date" name="date" class="form-control" value="{{ request('date', date('Y-m-d')) }}">
                <button type="submit" class="btn btn-primary">Filter</button>
            </div>
        </form>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-3">
                <div class="card">
                    <div class="card-body">
                        <h5>Total Requests</h5>
                        <p>Count: {{ $approvalsSummary->total_count }}</p>
                        <p>Amount: {{ number_format($approvalsSummary->total_sum, 2) }}</p>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card">
                    <div class="card-body">
                        <h5>Approved Requests</h5>
                        <p>Count: {{ $approvalsSummary->approved_count }}</p>
                        <p>Amount: {{ number_format($approvalsSummary->approved_sum, 2) }}</p>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card">
                    <div class="card-body">
                        <h5>Pending Requests</h5>
                        <p>Count: {{ $approvalsSummary->pending_count }}</p>
                        <p>Amount: {{ number_format($approvalsSummary->pending_sum, 2) }}</p>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card">
                    <div class="card-body">
                        <h5>Rejected Requests</h5>
                        <p>Count: {{ $approvalsSummary->rejected_count }}</p>
                        <p>Amount: {{ number_format($approvalsSummary->rejected_sum, 2) }}</p>
                    </div>
                </div>
            </div>
        </div>
         <div class="mt-2">
            <input type="text" id="search-input" class="form-control" placeholder="Search...">
        </div>

        <div class="table-responsive mt-4">
            <table class="table table-striped" id="approvals-table">
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Type</th>
                        <th>Customer/Supplier</th>
                        <th>Amount</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($approvals as $approval)
                        <tr>
                            <td>{{ $approval->date }}</td>
                            <td>{{ (get_class($approval) == 'App\Models\Recovery')?"Recovery":"Disbursement" }}</td>
                            <td>
                                @if (get_class($approval) === 'App\Models\Recovery')
                                    {{ $approval->customer->name ?? 'N/A' }}
                                @elseif (get_class($approval) === 'App\Models\Disbursement')
                                    {{ $approval->supplier->name ?? 'N/A' }}
                                @else
                                    N/A
                                @endif
                            </td>
                            <td>{{ number_format($approval->amount, 2) }}</td>
                            <td>{{ $approval->status ?? 'N/A' }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection

@section('customjs')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Search functionality (client-side)
        document.getElementById('search-input').addEventListener('keyup', function() {
            const searchText = this.value.toLowerCase();
            const rows = document.querySelectorAll('#approvals-table tbody tr');

            rows.forEach(row => {
                let found = false;
                row.querySelectorAll('td').forEach(cell => {
                    if (cell.textContent.toLowerCase().includes(searchText)) {
                        found = true;
                    }
                });
                row.style.display = found ? '' : 'none';
            });
        });
    });
</script>
@endsection