@extends('layouts.app')
@section('breadcrumb')
<div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
	<h4 class="mb-sm-0">Users</h4>
	<div class="page-title-right">
		<ol class="breadcrumb m-0">
			<li class="breadcrumb-item"><a href="{{ url('dashboard') }}">Dashboard</a></li>
			<li class="breadcrumb-item"><a href="{{ url('users') }}">users</a></li>
			<li class="breadcrumb-item active">{{ $user->name }} - Details</li>
		</ol>
	</div>
</div>
@endsection
@section('content')
<div class="row">
	<div class="col-md-4">
		<div class="card">
			<div class="card-header">
				<h5>User Details</h5>
			</div>
			<div class="card-body">
				<div class="mb-4">
					<label>Name</label>
					<div>{{ $user->name }}</div>
				</div>
				<div>
					<label>Email</label>
					<div>{{ $user->email }}</div>
				</div>
			</div>
		</div>
	</div>
	<div class="col-md-8">
		<form class="card" method="POST" action="{{ url('user_permissions') }}">
			@csrf
			<input type="hidden" name="user_id" value="{{ $user->id }}">
			<div class="card-header">
				<h5>Permission</h5>
			</div>
			<div class="card-body">
				<div class="row mb-3">
					<div class="col-md-2">
						<label>Collections</label>
					</div>
					<div class="col-md-2">
						<input type="checkbox" name="permission[]" id="create_collections" class="form-check-input collections create_collections" value="create collections" {{ $user->can('create collections') ? 'checked' :'' }}> <label for="create_collections">Create</label>
					</div>
					<div class="col-md-2">
						<input type="checkbox" name="permission[]" id="show_collections" class="form-check-input collections show_collections" value="show collections" {{ $user->can('show collections') ? 'checked' :'' }}> <label for="show_collections">Show</label>
					</div>
					<div class="col-md-2">
						<input type="checkbox" name="permission[]" id="edit_collections" class="form-check-input collections edit_collections" value="edit collections" {{ $user->can('edit collections') ? 'checked' :'' }}> <label for="edit_collections">Edit</label>
					</div>
					<div class="col-md-2">
						<input type="checkbox" name="permission[]" id="delete_collections" class="form-check-input collections delete_collections" value="delete collections" {{ $user->can('delete collections') ? 'checked' :'' }}> <label for="delete_collections">Delete</label>
					</div>
				</div>
				<div class="row mb-3">
					<div class="col-md-2">
						<label>Credits</label>
					</div>
					<div class="col-md-2">
						<input type="checkbox" name="permission[]" id="create_credits" class="form-check-input credits create_credits" value="create credits" {{ $user->can('create credits') ? 'checked' :'' }}> <label for="create_credits">Create</label>
					</div>
					<div class="col-md-2">
						<input type="checkbox" name="permission[]" id="show_credits" class="form-check-input credits show_credits" value="show credits" {{ $user->can('show credits') ? 'checked' :'' }}> <label for="show_credits">Show</label>
					</div>
					<div class="col-md-2">
						<input type="checkbox" name="permission[]" id="edit_credits" class="form-check-input credits edit_credits" value="edit credits" {{ $user->can('edit credits') ? 'checked' :'' }}> <label for="edit_credits">Edit</label>
					</div>
					<div class="col-md-2">
						<input type="checkbox" name="permission[]" id="delete_credits" class="form-check-input credits delete_credits" value="delete credits" {{ $user->can('delete credits') ? 'checked' :'' }}> <label for="delete_credits">Delete</label>
					</div>
				</div>
				<div class="row mb-3">
					<div class="col-md-2">
						<label>Discounts</label>
					</div>
					<div class="col-md-2">
						<input type="checkbox" name="permission[]" id="create_discounts" class="form-check-input discounts create_discounts" value="create discounts" {{ $user->can('create discounts') ? 'checked' :'' }}> <label for="create_discounts">Create</label>
					</div>
					<div class="col-md-2">
						<input type="checkbox" name="permission[]" id="show_discounts" class="form-check-input discounts show_discounts" value="show discounts" {{ $user->can('show discounts') ? 'checked' :'' }}> <label for="show_discounts">Show</label>
					</div>
					<div class="col-md-2">
						<input type="checkbox" name="permission[]" id="edit_discounts" class="form-check-input discounts edit_discounts" value="edit discounts" {{ $user->can('edit discounts') ? 'checked' :'' }}> <label for="edit_discounts">Edit</label>
					</div>
					<div class="col-md-2">
						<input type="checkbox" name="permission[]" id="delete_discounts" class="form-check-input discounts delete_discounts" value="delete discounts" {{ $user->can('delete discounts') ? 'checked' :'' }}> <label for="delete_discounts">Delete</label>
					</div>
				</div>
				<div class="row mb-3">
					<div class="col-md-2">
						<label>Intakes</label>
					</div>
					<div class="col-md-2">
						<input type="checkbox" name="permission[]" id="create_intakes" class="form-check-input intakes create_intakes" value="create intakes" {{ $user->can('create intakes') ? 'checked' :'' }}> <label for="create_intakes">Create</label>
					</div>
					<div class="col-md-2">
						<input type="checkbox" name="permission[]" id="show_intakes" class="form-check-input intakes show_intakes" value="show intakes" {{ $user->can('show intakes') ? 'checked' :'' }}> <label for="show_intakes">Show</label>
					</div>
					<div class="col-md-2">
						<input type="checkbox" name="permission[]" id="edit_intakes" class="form-check-input intakes edit_intakes" value="edit intakes" {{ $user->can('edit intakes') ? 'checked' :'' }}> <label for="edit_intakes">Edit</label>
					</div>
					<div class="col-md-2">
						<input type="checkbox" name="permission[]" id="delete_intakes" class="form-check-input intakes delete_intakes" value="delete intakes" {{ $user->can('delete intakes') ? 'checked' :'' }}> <label for="delete_intakes">Delete</label>
					</div>
				</div>
				<div class="row mb-3">
					<div class="col-md-2">
						<label>Transfers</label>
					</div>
					<div class="col-md-2">
						<input type="checkbox" name="permission[]" id="create_transfers" class="form-check-input transfers create_transfers" value="create transfers" {{ $user->can('create transfers') ? 'checked' :'' }}> <label for="create_transfers">Create</label>
					</div>
					<div class="col-md-2">
						<input type="checkbox" name="permission[]" id="show_transfers" class="form-check-input transfers show_transfers" value="show transfers" {{ $user->can('show transfers') ? 'checked' :'' }}> <label for="show_transfers">Show</label>
					</div>
					<div class="col-md-2">
						<input type="checkbox" name="permission[]" id="edit_transfers" class="form-check-input transfers edit_transfers" value="edit transfers" {{ $user->can('edit transfers') ? 'checked' :'' }}> <label for="edit_transfers">Edit</label>
					</div>
					<div class="col-md-2">
						<input type="checkbox" name="permission[]" id="delete_transfers" class="form-check-input transfers delete_transfers" value="delete transfers" {{ $user->can('delete transfers') ? 'checked' :'' }}> <label for="delete_transfers">Delete</label>
					</div>
				</div>
				<div class="row mb-3">
					<div class="col-md-2">
						<label>Recoveries</label>
					</div>
					<div class="col-md-2">
						<input type="checkbox" name="permission[]" id="create_recoveries" class="form-check-input recoveries create_recoveries" value="create recoveries" {{ $user->can('create recoveries') ? 'checked' :'' }}> <label for="create_recoveries">Create</label>
					</div>
					<div class="col-md-2">
						<input type="checkbox" name="permission[]" id="show_recoveries" class="form-check-input recoveries show_recoveries" value="show recoveries" {{ $user->can('show recoveries') ? 'checked' :'' }}> <label for="show_recoveries">Show</label>
					</div>
					<div class="col-md-2">
						<input type="checkbox" name="permission[]" id="edit_recoveries" class="form-check-input recoveries edit_recoveries" value="edit recoveries" {{ $user->can('edit recoveries') ? 'checked' :'' }}> <label for="edit_recoveries">Edit</label>
					</div>
					<div class="col-md-2">
						<input type="checkbox" name="permission[]" id="delete_recoveries" class="form-check-input recoveries delete_recoveries" value="delete recoveries" {{ $user->can('delete recoveries') ? 'checked' :'' }}> <label for="delete_recoveries">Delete</label>
					</div>
				</div>
				<div class="row mb-3">
					<div class="col-md-2">
						<label>Expenses</label>
					</div>
					<div class="col-md-2">
						<input type="checkbox" name="permission[]" id="create_expenses" class="form-check-input expenses create_expenses" value="create expenses" {{ $user->can('create expenses') ? 'checked' :'' }}> <label for="create_expenses">Create</label>
					</div>
					<div class="col-md-2">
						<input type="checkbox" name="permission[]" id="show_expenses" class="form-check-input expenses show_expenses" value="show expenses" {{ $user->can('show expenses') ? 'checked' :'' }}> <label for="show_expenses">Show</label>
					</div>
					<div class="col-md-2">
						<input type="checkbox" name="permission[]" id="edit_expenses" class="form-check-input expenses edit_expenses" value="edit expenses" {{ $user->can('edit expenses') ? 'checked' :'' }}> <label for="edit_expenses">Edit</label>
					</div>
					<div class="col-md-2">
						<input type="checkbox" name="permission[]" id="delete_expenses" class="form-check-input expenses delete_expenses" value="delete expenses" {{ $user->can('delete expenses') ? 'checked' :'' }}> <label for="delete_expenses">Delete</label>
					</div>
				</div>
				<div class="row mb-3">
					<div class="col-md-2">
						<label>Payments</label>
					</div>
					<div class="col-md-2">
						<input type="checkbox" name="permission[]" id="create_payments" class="form-check-input payments create_payments" value="create payments" {{ $user->can('create payments') ? 'checked' :'' }}> <label for="create_payments">Create</label>
					</div>
					<div class="col-md-2">
						<input type="checkbox" name="permission[]" id="show_payments" class="form-check-input payments show_payments" value="show payments" {{ $user->can('show payments') ? 'checked' :'' }}> <label for="show_payments">Show</label>
					</div>
					<div class="col-md-2">
						<input type="checkbox" name="permission[]" id="edit_payments" class="form-check-input payments edit_payments" value="edit payments" {{ $user->can('edit payments') ? 'checked' :'' }}> <label for="edit_payments">Edit</label>
					</div>
					<div class="col-md-2">
						<input type="checkbox" name="permission[]" id="delete_payments" class="form-check-input payments delete_payments" value="delete payments" {{ $user->can('delete payments') ? 'checked' :'' }}> <label for="delete_payments">Delete</label>
					</div>
				</div>
				<div class="row mb-3">
					<div class="col-md-2">
						<label>Summaries</label>
					</div>
					<div class="col-md-2">
						<input type="checkbox" name="permission[]" id="create_summaries" class="form-check-input summaries create_summaries" value="create summaries" {{ $user->can('create summaries') ? 'checked' :'' }}> <label for="create_summaries">Create</label>
					</div>
					<div class="col-md-2">
						<input type="checkbox" name="permission[]" id="show_summaries" class="form-check-input summaries show_summaries" value="show summaries" {{ $user->can('show summaries') ? 'checked' :'' }}> <label for="show_summaries">Show</label>
					</div>
					<div class="col-md-2">
						<input type="checkbox" name="permission[]" id="edit_summaries" class="form-check-input summaries edit_summaries" value="edit summaries" {{ $user->can('edit summaries') ? 'checked' :'' }}> <label for="edit_summaries">Edit</label>
					</div>
					<div class="col-md-2">
						<input type="checkbox" name="permission[]" id="delete_summaries" class="form-check-input summaries delete_summaries" value="delete summaries" {{ $user->can('delete summaries') ? 'checked' :'' }}> <label for="delete_summaries">Delete</label>
					</div>
				</div>

				<div class="row mb-3">
					<div class="col-md-2">
						<label>Profits</label>
					</div>
					<div class="col-md-2">
						<input type="checkbox" name="permission[]" id="create_profits" class="form-check-input profits create_profits" value="create profits" {{ $user->can('create profits') ? 'checked' :'' }}> <label for="create_profits">Create</label>
					</div>
					<div class="col-md-2">
						<input type="checkbox" name="permission[]" id="show_profits" class="form-check-input profits show_profits" value="show profits" {{ $user->can('show profits') ? 'checked' :'' }}> <label for="show_profits">Show</label>
					</div>
					<div class="col-md-2">
						<input type="checkbox" name="permission[]" id="edit_profits" class="form-check-input profits edit_profits" value="edit profits" {{ $user->can('edit profits') ? 'checked' :'' }}> <label for="edit_profits">Edit</label>
					</div>
					<div class="col-md-2">
						<input type="checkbox" name="permission[]" id="delete_profits" class="form-check-input profits delete_profits" value="delete profits" {{ $user->can('delete profits') ? 'checked' :'' }}> <label for="delete_profits">Delete</label>
					</div>
				</div>
				{{-- <div class="row mb-3">
					<div class="col-md-2">
						<label>Customers</label>
					</div>
					<div class="col-md-2">
						<input type="checkbox" name="permission[]" id="create_collections" class="form-check-input collections create_collections" value="create collections" {{ $user->can('create collections') ? 'checked' :'' }}> <label for="create_collections">Create</label>
					</div>
					<div class="col-md-2">
						<input type="checkbox" name="permission[]" id="show_collections" class="form-check-input collections show_collections" value="show collections" {{ $user->can('show collections') ? 'checked' :'' }}> <label for="show_collections">Show</label>
					</div>
					<div class="col-md-2">
						<input type="checkbox" name="permission[]" id="edit_collections" class="form-check-input collections edit_collections" value="edit collections" {{ $user->can('edit collections') ? 'checked' :'' }}> <label for="edit_collections">Edit</label>
					</div>
					<div class="col-md-2">
						<input type="checkbox" name="permission[]" id="delete_collections" class="form-check-input collections delete_collections" value="delete collections" {{ $user->can('delete collections') ? 'checked' :'' }}> <label for="delete_collections">Delete</label>
					</div>
				</div>
 --}}		</div>
 			<div class="card-footer d-flex align-items-center justify-content-between">
 				<a href="{{ url('users') }}" class="btn btn-light">Cancel</a>
 				<button type="submit" class="btn btn-primary">Update Permissions</button>
 			</div>
		</form>
	</div>
</div>
@endsection