@extends('layouts.app')
@section('breadcrumb')
<div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
	<h4 class="mb-sm-0">Daily Summaries</h4>
	<div class="page-title-right">
		<ol class="breadcrumb m-0">
			<li class="breadcrumb-item"><a href="{{ url('dashboard') }}">Dashboard</a></li>
			<li class="breadcrumb-item active">Daily Summaries</li>
		</ol>
	</div>
</div>
@endsection
@section('content')
<div>
	<div class="card">
		<div class="card-header d-flex flex-row align-items-center justify-content-between">
			<h5>Summaries</h5>
			<a href="{{ url('summaries/create') }}" class="btn btn-primary">Create New Summary</a>
		</div>
		<div class="card-body">
			{{-- <table class="table table-striped table-responsive table-hover dataTable">
				<thead role="rowgroup">
					<tr role="row">
						<th role='columnheader'>Name</th>
						<th>Date</th>
						<th>Personel</th>
						<th>Status</th>
						<th>User</th>
						<th scope="col" data-label="Actions">Actions</th>
					</tr>
				</thead>
				<tbody>
					@foreach($summaries as $summary)
					<tr>
						<td data-label="Name">
							{{ $summary->branch ? $summary->branch?->name: "-" }}
						</td>
						<td>
							{{ $summary->date? date("d-M-Y",strtotime($summary->date)):'-' }}
						</td>
						<td>
							{{ $summary->personel? $summary->personel?->name:'-' }}
						</td>
						<td>
							{{ $summary->status? :'-' }}
						</td>
						<td>
							{{ $summary->user? $summary->user?->name:'-' }}
						</td>

						<td>
							@if($summary->status == "Open")
								<a href="{{ url('summaries/modules/'.$summary->id) }}" class="btn btn-danger btn-sm">Continue</a>
							@else
								<a href="{{ url('summaries/'.$summary->id) }}" class="btn btn-primary btn-sm">Show</a>
							@endif
						</td>
					</tr>
					@endforeach
				</tbody>
			</table> --}}
			<div class="table-responsive">
				<table id="records-table" class="table table-bordered table-striped">
	                <thead>
	                    <tr>
	                    	<th>Rec ID</th>
	                        <th>Branch</th>
	                        <th>Date</th>
	                        <th>Personnel</th>
	                        <th>Opening Balance</th>
	                        <th>Closing Balance</th>
	                        <th>User</th>
	                        <th>Actions</th>
	                    </tr>
	                </thead>
	                <tbody>
	                    <!-- DataTables will populate this -->
	                </tbody>
	            </table>
			</div>
		</div>
	</div>
</div>
@endsection
@section('customjs')
<script>
$(document).ready(function() {
    $('#records-table').DataTable({
        processing: true,
        serverSide: true,
        ajax: "{{ route('summaries.index') }}", // Replace with your actual route
        columns: [
        	{ data: 'id', name: 'id'},
            { data: 'branch_name', name: 'branch_name' },
            { data: 'date', name: 'date' },
            { data: 'personel', name: 'personel' },
            { data: 'opening_balance', name: 'opening_balance' },
            { data: 'closing_balance', name: 'closing_balance' },
            { data: 'user', name: 'user' },
            { data: 'actions', name: 'actions', orderable: false, searchable: false }
        ],
        order: [[0, 'desc']] // Default order by date
    });

});
</script>
@endsection