@extends('layouts.app')
@section('breadcrumb')
<div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
    <h4 class="mb-sm-0">Daily Summaries</h4>
    <div class="page-title-right">
        <ol class="breadcrumb m-0">
            <li class="breadcrumb-item"><a href="{{ url('dashboard') }}">Dashboard</a></li>
            <li class="breadcrumb-item"><a href="{{ url('summaries') }}">Daily Summaries</a></li>
            <li class="breadcrumb-item"><a href="javascript:void(0);">{{ $summary->branch?->name }}</a></li>
            <li class="breadcrumb-item"><a href="{{ url('summaries/modules/'.$summary->id) }}">{{ date('d M, Y',strtotime($summary->date)) }}</a></li>
            <li class="breadcrumb-item active">Expenses</li>
        </ol>
    </div>
</div>
@endsection
@section('content')
<div class="card">
    <div class="card-header">
        @include('layouts.summaries_menu')
    </div>
    <div class="card-body">
        <form action="{{ url('expenses') }}" method="POST">
            @csrf
            <input type="hidden" name="summary_id" value="{{ $summary->id }}">
            
            <div class="repeater">
                <table class="table">
                    <thead>
                        <th>Expense Item</th>
                        <th>Amount</th>
                    </thead>
                    <tbody data-repeater-list="items">
                        <tr data-repeater-item>
                            <td>
                                <select class="form-control form-select select2" name="expense_item_id" required>
                                        <option></option>
                                        @foreach($expense_items as $expense_item)
                                            <option value="{{ $expense_item->id }}">{{ $expense_item->name }}</option>
                                        @endforeach
                                    </select>
                            </td>
                            <td>
                                <input type="number" name="amount" class="form-control amount" required>
                                <div class="text-end">
                                    <button type="button" data-repeater-delete class="btn btn-danger">Delete</button>
                                </div>
                            </td>
                        </tr>
                    </tbody>
                </table>
                <button type="button" data-repeater-create class="btn btn-primary">Add</button>
            </div>
            <div class="mt-4">
                <div class="row">
                    <div class="col-md-3 offset-md-9">
                        <div class="form-group">
                            <label for="grand-total">Grand Total:</label>
                            <input type="text" id="grand-total" class="form-control" disabled>
                        </div>
                    </div>
                </div>
            </div>
            <div class="d-flex flex-row align-items-center justify-content-between">
                <a href="{{ url('transfers/create') }}?summary_id={{ $summary->id }}" class="btn btn-info">Cancel</a>
                <button type="submit" class="btn btn-success">Save</button>
            </div>
        </form>
    </div>
</div>
@endsection

@section('customjs')
<script type="text/javascript">
    $(document).ready(function () {
                $('.select2').select2()
        var $repeater = $('.repeater').repeater({
            initEmpty: true,
            show: function () {
                $(this).slideDown();
                $('.select2-container').remove();
                $('.select2').select2()
                bindEvents($(this));
            },
            hide: function (deleteElement) {
                $(this).slideUp(deleteElement, function() {
                    $(this).remove();
                    calculateGrandTotal();
                });
            }
        });

        @if(old('items'))
            $repeater.setList(@json(old('items')));
        @elseif($expenses->count() > 0)
            $repeater.setList([
                @foreach ($expenses as $expense)
                    {
                        expense_item_id: '{{ $expense->expense_item_id }}',
                        amount: '{{ $expense->amount }}',
                    },
                @endforeach
            ]);
        @endif

        calculateGrandTotal();

        // Bind the event functions to all initial repeater items
        $('.repeater [data-repeater-item]').each(function() {
            bindEvents($(this));
        });

        function bindEvents(item) {
            item.find('.inventory-select').on('change', function() {
                var selectedRate = $(this).find(':selected').data('rate') || 0;
                item.find('.amount').val(selectedRate).trigger('input');
            });

            item.find('.amount').on('input', function() {
                var amount = parseFloat(item.find('.amount').val()) || 0;
                // var quantity = parseFloat(item.find('.quantity').val()) || 0;
                // var total = rate * quantity;
                // item.find('.total').val(total);
                calculateGrandTotal();
            });
        }

        function calculateGrandTotal() {
            var grandTotal = 0;
            $('.repeater .amount').each(function() {
                var total = parseFloat($(this).val()) || 0;
                grandTotal += total;
            });
            $('#grand-total').val(grandTotal.toLocaleString());
        }
    });
</script>
@endsection