@extends('layouts.app')
@section('breadcrumb')
<div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
    <h4 class="mb-sm-0">Daily Summaries</h4>
    <div class="page-title-right">
        <ol class="breadcrumb m-0">
            <li class="breadcrumb-item"><a href="{{ url('dashboard') }}">Dashboard</a></li>
            <li class="breadcrumb-item"><a href="{{ url('summaries') }}">Daily Summaries</a></li>
            <li class="breadcrumb-item"><a href="javascript:void(0);">{{ $summary->branch?->name }}</a></li>
            <li class="breadcrumb-item"><a href="{{ url('summaries/modules/'.$summary->id) }}">{{ date('d M, Y',strtotime($summary->date)) }}</a></li>
            <li class="breadcrumb-item active">Discounts</li>
        </ol>
    </div>
</div>
@endsection
@section('content')
<div class="card">
    <div class="card-header">
        @include('layouts.summaries_menu')
    </div>
    <div class="card-body">
        <form action="{{ url('discounts') }}" method="POST">
            @csrf
            <input type="hidden" name="summary_id" value="{{ $summary->id }}">
            <div class="repeater">
                <table class="table">
                    <thead>
                        <th width="35%">Customer</th>
                        <th width="25%">Inventory</th>
                        <th width="10%">Rate</th>
                        <th width="10%">Quantity</th>
                        <th width="10%">Total</th>
                    </thead>
                    <tbody data-repeater-list="items">
                        <tr data-repeater-item>
                            <td>
                                <select class="form-control form-select select2" name="customer_id" required>
                                    <option></option>
                                    @foreach($customers as $customer)
                                        <option value="{{ $customer->id }}">{{ $customer->name }}</option>
                                    @endforeach
                                </select>
                            </td>
                            <td>
                                <select class="form-control form-select select2" name="inventory_id" required>
                                    <option></option>
                                    @foreach($inventories as $inventory)
                                        <option value="{{ $inventory->id }}">{{ $inventory->name }}</option>
                                    @endforeach
                                </select>
                            </td>
                            <td>
                                <input type="text" name="rate" class="form-control rate" required>
                            </td>
                            <td>
                                <input type="text" name="quantity" class="form-control quantity" required>
                            </td>
                            <td>
                                <input type="text" name="total" class="form-control total" disabled>
                                <div class="text-end">
                                    <button type="button" data-repeater-delete class="btn btn-danger">Delete</button>
                                </div>
                            </td>
                        </tr>
                    </tbody>
                </table>
                <button type="button" data-repeater-create class="btn btn-primary">Add</button>
            </div>
            <div class="mt-4">
                <div class="row">
                    <div class="col-md-3 offset-md-9">
                        <div class="form-group">
                            <label for="grand-total">Grand Total:</label>
                            <input type="text" id="grand-total" class="form-control" disabled>
                        </div>
                    </div>
                </div>
            </div>
            <div class="d-flex flex-row align-items-center justify-content-between">
                <a href="{{ url('credits/create') }}?summary_id={{ $summary->id }}" class="btn btn-info">Back</a>
                <button type="submit" class="btn btn-success">Save</button>
            </div>
        </form>
    </div>
</div>
@endsection

@section('customjs')
<script type="text/javascript">
    $(document).ready(function () {
        $('.select2').select2()
        var $repeater = $('.repeater').repeater({
            initEmpty: true,
            show: function () {
                $(this).slideDown();
                $('.select2-container').remove();
                $('.select2').select2()
                bindTotalCalculation($(this));
            },
            hide: function (deleteElement) {
                $(this).slideUp(deleteElement, function() {
                    $(this).remove();
                    calculateGrandTotal();
                });
            }
        });

        @if(old('items'))
            $repeater.setList(@json(old('items')));
        @elseif($discounts->count() > 0)
            $repeater.setList([
                @foreach ($discounts as $discount)
                {
                    'customer_id' : '{{ $discount->customer_id }}',
                    'inventory_id': '{{ $discount->inventory_id }}',
                    'rate': '{{ $discount->discount_rate }}',
                    'quantity': '{{ $discount->quantity }}',
                    'total': '{{ $discount->total_discount }}',
                },
                @endforeach
            ]);
        @endif

        calculateGrandTotal();

        // Bind the total calculation function to all initial repeater items
        $('.repeater [data-repeater-item]').each(function() {
            bindTotalCalculation($(this));
        });

        function bindTotalCalculation(item) {
            item.find('.rate, .quantity').on('input', function() {
                var rate = parseFloat(item.find('.rate').val()) || 0;
                var quantity = parseFloat(item.find('.quantity').val()) || 0;
                var total = rate * quantity;
                item.find('.total').val(total);
                calculateGrandTotal();
            });
        }

        function calculateGrandTotal() {
            var grandTotal = 0;
            $('.repeater .total').each(function() {
                var total = parseFloat($(this).val()) || 0;
                grandTotal += total;
            });
            $('#grand-total').val(grandTotal.toLocaleString());
        }
    });
</script>
@endsection
