<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('disbursements', function (Blueprint $table) {
            $table->id();
            $table->string('date');
            $table->integer('orderNo');
            $table->integer('supplier_id');
            $table->integer('personel_id');
            $table->string('amount');
            $table->string('balance');
            $table->string('reason')->nullable();
            $table->enum('status',['Approved','Pending','Rejected']);
            $table->integer('user_id');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('disbursements');
    }
};
