<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Transfer extends Model
{
    use HasFactory;

    /**
     * Transfer belongs to Destination.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function destination()
    {
        // belongsTo(RelatedModel, foreignKey = destination_id, keyOnRelatedModel = id)
        return $this->belongsTo(Branch::class,'destination_branch_id');
    }

    /**
     * Transfer belongs to Source.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function source()
    {
        // belongsTo(RelatedModel, foreignKey = source_id, keyOnRelatedModel = id)
        return $this->belongsTo(Branch::class,'source_branch_id');
    }

    /**
     * Transfer belongs to Inventory.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function inventory()
    {
        // belongsTo(RelatedModel, foreignKey = inventory_id, keyOnRelatedModel = id)
        return $this->belongsTo(Inventory::class);
    }
}
