<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Supplier extends Model
{
    use HasFactory,softDeletes;

    /**
     * Supplier has many Intakes.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function intakes()
    {
        // hasMany(RelatedModel, foreignKeyOnRelatedModel = supplier_id, localKey = id)
        return $this->hasMany(Intake::class);
    }

    /**
     * Supplier has many Payments.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function payments()
    {
        // hasMany(RelatedModel, foreignKeyOnRelatedModel = supplier_id, localKey = id)
        return $this->hasMany(Payment::class);
    }
}
