<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class GeneralExpense extends Model
{
    use HasFactory,SoftDeletes;

    protected $fillable = [
        'expense_date',
        'reference',
        'supplier_id',
        'expense_item_id',
        'payment_method_id',
        'amount',
        'paid_amount',
        'balance',
        'narration',
        'status',
    ];

    public function supplier()
    {
        return $this->belongsTo(Supplier::class);
    }

    public function expenseItem()
    {
        return $this->belongsTo(ExpenseItem::class);
    }

    public function payment_method()
    {
        return $this->belongsTo(PaymentMethod::class);
    }
}
