<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Branch;
use App\Models\Summary;
use App\Models\Inventory;
use App\Models\Transfer;

class TransfersController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $transfers = Transfer::query();

        if ($request->date) {
            $transfers->whereDate('date',$request->date);
        }

        if ($request->source_branch_id) {
            $transfers->where('source_branch_id',$request->source_branch_id);
        }

        if ($request->destination_branch_id) {
            $transfers->where('destination_branch_id',$request->destination_branch_id);
        }

        if ($request->branch_id) {
            $transfers->whereHas('summary', function($query) use($request){
                $query->where('branch_id',$request->branch_id);
            });
        }

        if ($request->inventory_id) {
            $transfers->where('inventory_id',$request->inventory_id);
        }

        $inventories = Inventory::all();
        $branches = Branch::get();

        $transfers = $transfers->get();

        return view('transfers.index',compact('transfers','branches','inventories'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create(Request $request)
    {
        $summary = Summary::find($request->summary_id);

        $branches = Branch::where('id','!=',$summary->branch_id)->get();
        $inventories = Inventory::all();

        $transfers = Transfer::where('summary_id',$summary->id)->get();

        return view('transfers.create',compact('branches','summary','inventories','transfers'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $summary = Summary::find($request->summary_id);

        try{
            $total = 0;
            \DB::beginTransaction();

            Transfer::where('summary_id',$summary->id)->delete();

            foreach($request->items as $item){
                if (gettype($item) == "array") 
                    {
                        $item = json_encode($item);
                    }

                $item = json_decode($item);
                
                $Transfer = new Transfer;

                $item->rate = str_replace(",", "", $item->rate);
                $item->quantity = str_replace(",", "", $item->quantity);

                $Transfer = new Transfer;
                $Transfer->summary_id = $summary->id;
                $Transfer->date = $summary->date;
                $Transfer->source_branch_id = $summary->branch_id;
                $Transfer->destination_branch_id = $item->branch_id;
                $Transfer->inventory_id = $item->inventory_id;
                $Transfer->rate = $item->rate;
                $Transfer->quantity = $item->quantity;
                $Transfer->amount = $item->quantity * $item->rate;
                $Transfer->created_by_id = \Auth::user()->id;
                $Transfer->save();

                $total += $Transfer->amount;
            }

            $summary->transfers = $total;
            $summary->save();

            \DB::commit();

            return redirect()->back()->with('success','Stock Transfers have been saved!');
        }catch(\Throwable $ex){
            return redirect()->back()->withErrors(['error'=>$ex->getMessage()])->withInput();
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
