<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Purchase;
use App\Models\Inventory;
use App\Models\PurchaseItem;
use App\Models\Supplier;
use App\Models\Ledger;

class PurchasesController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $purchases = Purchase::all();
        return view('purchases.index',compact('purchases'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $items = Inventory::all();
        $suppliers = Supplier::all();
        return view('purchases.create',compact('items','suppliers'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'date' => 'required',
            'supplier' => 'required',
        ]);
        
        try {
            \DB::beginTransaction();
            $purchase = new Purchase;
            $count = Purchase::count();
            $purchase->date = $request->date;
            $purchase->purchase_no = sprintf('%04d',$count+1);
            $purchase->reference = $request->reference;
            $purchase->supplier_id = $request->supplier;
            $purchase->status = "Draft";
            $purchase->save();

            foreach($request->items as $item){
                if (gettype($item) == "array") 
                {
                    $item = json_encode($item);
                }

                $item = json_decode($item);

                $item->rate = str_replace(',', '', $item->rate);
                $item->quantity = str_replace(',', '', $item->quantity);

                $credit = new PurchaseItem;
                $credit->inventory_id = $item->item_id;
                $credit->purchase_id = $purchase->id;
                $credit->rate = $item->rate;
                $credit->quantity = $item->quantity;
                $credit->total = $item->rate * $item->quantity;
                $credit->save();
            }

            \DB::commit();

             return redirect('purchases/'.$purchase->id)->with('success','Purchase saved successfully!');

        } catch (\Throwable $ex) {
            \DB::rollBack();
            return redirect()->back()->withInput($request->input())->withErrors(['error' => $ex->getMessage()]);
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        $purchase = Purchase::find($id);
        return view('purchases.show',compact('purchase'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }

    public function  approve($id){
        try{
            \DB::beginTransaction();
            $purchase = Purchase::find($id);
            $purchase->status = "Approved";
            $purchase->save();

            $total = 0;

            foreach($purchase->items as $item){
                $total += $item->total;
            }

            $supplier = $purchase->supplier;

            $ledger = new Ledger;
            $ledger->label = "General Purchase";
            $ledger->supplier_id = $purchase->supplier_id;
            $ledger->debit = $total;
            $ledger->date = $purchase->date;
            $ledger->balance = $supplier->balance + $total;
            $ledger->purchase_id = $purchase->id;
            $ledger->save();

            $supplier->balance = $ledger->balance;
            $supplier->save();

            \DB::commit();

            return redirect('purchases/'.$purchase->id)->with('success','Purchase saved approved!');
        }catch(\Throwable $ex){
            \DB::rollBack();
            return redirect()->back()->withInput($request->input())->withErrors(['error' => $ex->getMessage()]);
        }
    }
}
