<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Models\Personel;

class PersonelController extends Controller {

    public function __construct() {
		// $this->authorizeResource(Personel::class, 'personel');
	}

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request, ) {

        $personels = Personel::query();

		if (!!$request->trashed) {
			$personels->withTrashed();
		}

        if(!empty($request->search)) {
			$personels->where('name', 'like', '%' . $request->search . '%');
		}

        $personels = $personels->paginate(10);

        return view('personels.index', compact('personels'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create() {

        return view('personels.create', []);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request, ) {

        $request->validate(["name" => "required", "station" => "required", "status" => "required"]);

        try {

            $personel = new Personel();
            $personel->name = $request->name;
		$personel->station = $request->station;
		$personel->status = $request->status;
            $personel->save();

            return redirect()->route('personels.index', [])->with('success', __('Personel created successfully.'));
        } catch (\Throwable $e) {
            return redirect()->route('personels.create', [])->withInput($request->input())->withErrors(['error' => $e->getMessage()]);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param \App\Models\Personel $personel
     *
     * @return \Illuminate\Http\Response
     */
    public function show(Personel $personel,) {

        return view('personels.show', compact('personel'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param \App\Models\Personel $personel
     *
     * @return \Illuminate\Http\Response
     */
    public function edit(Personel $personel,) {

        return view('personels.edit', compact('personel'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Personel $personel,) {

        $request->validate(["name" => "required", "station" => "required", "status" => "required"]);

        try {
            $personel->name = $request->name;
    		$personel->station = $request->station;
    		$personel->status = $request->status;
            $personel->save();

            return redirect()->route('personels.index', [])->with('success', __('Personel edited successfully.'));
        } catch (\Throwable $e) {
            return redirect()->route('personels.edit', compact('personel'))->withInput($request->input())->withErrors(['error' => $e->getMessage()]);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param \App\Models\Personel $personel
     *
     * @return \Illuminate\Http\Response
     */
    public function destroy(Personel $personel,) {

        try {
            $personel->delete();

            return redirect()->route('personels.index', [])->with('success', __('Personel deleted successfully'));
        } catch (\Throwable $e) {
            return redirect()->route('personels.index', [])->with('error', 'Cannot delete Personel: ' . $e->getMessage());
        }
    }

    //@softdelete

    /**
     * Restore the specified deleted resource from storage.
     *
     * @param \App\Models\Personel $personel
     *
     * @return \Illuminate\Http\Response
     */
    public function restore( int $personel_id,) {

        $personel = Personel::withTrashed()->find($personel_id);
        // $this->authorize('delete', [Personel::class, $personel]);

        if (!empty($personel)) {
            $personel->restore();
            return redirect()->route('personels.index', [])->with('success', __('Personel restored successfully'));
        } else {
            return redirect()->route('personels.index', [])->with('error', 'Personel not found');
        }
    }

    public function purge( int $personel_id,) {

        $personel = Personel::withTrashed()->find($personel_id);
        // $this->authorize('delete', [Personel::class, $personel]);

        if (!empty($personel)) {
            $personel->forceDelete();
            return redirect()->route('personels.index', [])->with('success', __('Personel purged successfully'));
        } else {
            return redirect()->route('personels.index', [])->with('error', __('Personel not found'));
        }
    }
    //@endsoftdelete
}
