<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Models\Summary;
use App\Models\ExpenseItem;
use App\Models\Expense;

class ExpensesController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create(Request $request)
    {
        $summary = Summary::find($request->summary_id);
        $expense_items = ExpenseItem::all();

        $expenses = Expense::where('summary_id',$summary->id)->get();
        return view('expenses.create',compact('summary','expense_items','expenses'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        try{
            $summary = Summary::find($request->summary_id);

            $total = 0;

            \DB::beginTransaction();

            Expense::where('summary_id',$summary->id)->delete();

            foreach($request->items as $item){
                if (gettype($item) == "array") 
                {
                    $item = json_encode($item);
                }

                $item = json_decode($item);

                $credit = new Expense;
                $credit->summary_id = $summary->id;
                $credit->date = $summary->date;
                $credit->branch_id = $summary->branch_id;
                $credit->expense_item_id = $item->expense_item_id;
                $credit->amount = $item->amount;
                $credit->created_by_id = \Auth::user()->id;
                $credit->save();

                $total += $credit->amount;
            }

            $summary->expenses = $total;
            $summary->save();

            \DB::commit();

            return redirect()->back()->with('success','Expenses have been saved successfully!');
        }catch(\Throwable $ex){
            return $ex->getMessage();
            return redirect()->back()->withErrors(['error'=>$ex->getMessage()])->withInput();
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
