<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\ExpenseItem;

class ExpenseItemsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request, ) {

        $expense_items = ExpenseItem::query();

        if (!!$request->trashed) {
            $expense_items->withTrashed();
        }

        if(!empty($request->search)) {
            $expense_items->where('name', 'like', '%' . $request->search . '%');
        }

        $expense_items = $expense_items->paginate(10);

        return view('expense_items.index', compact('expense_items'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create() {

        return view('expense_items.create', []);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request, ) {

        $request->validate(["name" => "required"]);

        try {

            $expense_item = new ExpenseItem();
            $expense_item->name = $request->name;
            $expense_item->save();

            return redirect()->route('expense_items.index', [])->with('success', __('Expense Item created successfully.'));
        } catch (\Throwable $e) {
            return redirect()->route('expense_items.create', [])->withInput($request->input())->withErrors(['error' => $e->getMessage()]);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param \App\Models\Branch $branch
     *
     * @return \Illuminate\Http\Response
     */
    public function show(ExpenseItem $expense_item,) {

        return view('expense_items.show', compact('expense_item'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param \App\Models\Branch $branch
     *
     * @return \Illuminate\Http\Response
     */
    public function edit(ExpenseItem $expense_item,) {

        return view('expense_items.edit', compact('expense_item'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, ExpenseItem $expense_item,) {

        $request->validate(["name" => "required"]);

        try {
            $expense_item->name = $request->name;
            $expense_item->save();

            return redirect()->route('expense_items.index', [])->with('success', __('Expense Item edited successfully.'));
        } catch (\Throwable $e) {
            return redirect()->route('expense_items.edit', compact('expense_item'))->withInput($request->input())->withErrors(['error' => $e->getMessage()]);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param \App\Models\Branch $branch
     *
     * @return \Illuminate\Http\Response
     */
    public function destroy(ExpenseItem $expense_item,) {

        try {
            $expense_item->delete();

            return redirect()->route('expense_items.index', [])->with('success', __('Expense Item deleted successfully'));
        } catch (\Throwable $e) {
            return redirect()->route('expense_items.index', [])->with('error', 'Cannot delete Expense Item: ' . $e->getMessage());
        }
    }

    //@softdelete

    /**
     * Restore the specified deleted resource from storage.
     *
     * @param \App\Models\Branch $branch
     *
     * @return \Illuminate\Http\Response
     */
    public function restore( int $expense_item_id,) {

        $expense_item = Branch::withTrashed()->find($expense_item_id);
        // $this->authorize('delete', [Branch::class, $branch]);

        if (!empty($expense_item)) {
            $expense_item->restore();
            return redirect()->route('expense_items.index', [])->with('success', __('Expense Item restored successfully'));
        } else {
            return redirect()->route('branches.index', [])->with('error', 'Expense Item not found');
        }
    }

    public function purge( int $expense_item_id,) {

        $expense_item = ExpenseItem::withTrashed()->find($expense_item_id);
        // $this->authorize('delete', [Branch::class, $expense_item]);

        if (!empty($expense_item)) {
            $expense_item->forceDelete();
            return redirect()->route('expense_items.index', [])->with('success', __('Expense Item purged successfully'));
        } else {
            return redirect()->route('expense_items.index', [])->with('error', __('Expense Item not found'));
        }
    }
    //@endsoftdelete
}
