<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Models\Branch;

class BranchController extends Controller {

    public function __construct() {
		// $this->authorizeResource(Branch::class, 'branch');
	}

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request, ) {

        $branches = Branch::query();

		if (!!$request->trashed) {
			$branches->withTrashed();
		}

        if(!empty($request->search)) {
			$branches->where('name', 'like', '%' . $request->search . '%');
		}

        $branches = $branches->paginate(10);

        return view('branches.index', compact('branches'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create() {

        return view('branches.create', []);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request, ) {

        $request->validate(["name" => "required"]);

        try {

            $branch = new Branch();
            $branch->name = $request->name;
            $branch->save();

            return redirect()->route('branches.index', [])->with('success', __('Branch created successfully.'));
        } catch (\Throwable $e) {
            return redirect()->route('branches.create', [])->withInput($request->input())->withErrors(['error' => $e->getMessage()]);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param \App\Models\Branch $branch
     *
     * @return \Illuminate\Http\Response
     */
    public function show(Branch $branch,) {

        return view('branches.show', compact('branch'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param \App\Models\Branch $branch
     *
     * @return \Illuminate\Http\Response
     */
    public function edit(Branch $branch,) {

        return view('branches.edit', compact('branch'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Branch $branch,) {

        $request->validate(["name" => "required"]);

        try {
            $branch->name = $request->name;
            $branch->save();

            return redirect()->route('branches.index', [])->with('success', __('Branch edited successfully.'));
        } catch (\Throwable $e) {
            return redirect()->route('branches.edit', compact('branch'))->withInput($request->input())->withErrors(['error' => $e->getMessage()]);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param \App\Models\Branch $branch
     *
     * @return \Illuminate\Http\Response
     */
    public function destroy(Branch $branch,) {

        try {
            $branch->delete();

            return redirect()->route('branches.index', [])->with('success', __('Branch deleted successfully'));
        } catch (\Throwable $e) {
            return redirect()->route('branches.index', [])->with('error', 'Cannot delete Branch: ' . $e->getMessage());
        }
    }

    //@softdelete

    /**
     * Restore the specified deleted resource from storage.
     *
     * @param \App\Models\Branch $branch
     *
     * @return \Illuminate\Http\Response
     */
    public function restore( int $branch_id,) {

        $branch = Branch::withTrashed()->find($branch_id);
        $this->authorize('delete', [Branch::class, $branch]);

        if (!empty($branch)) {
            $branch->restore();
            return redirect()->route('branches.index', [])->with('success', __('Branch restored successfully'));
        } else {
            return redirect()->route('branches.index', [])->with('error', 'Branch not found');
        }
    }

    public function purge( int $branch_id,) {

        $branch = Branch::withTrashed()->find($branch_id);
        $this->authorize('delete', [Branch::class, $branch]);

        if (!empty($branch)) {
            $branch->forceDelete();
            return redirect()->route('branches.index', [])->with('success', __('Branch purged successfully'));
        } else {
            return redirect()->route('branches.index', [])->with('error', __('Branch not found'));
        }
    }
    //@endsoftdelete
}
