<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Disbursement;
use App\Models\Recovery;
use App\Helpers\Restructure;
use App\Models\Payment;
use App\Models\Customer;
use App\Models\Supplier;
use App\Models\GeneralExpense;
use App\Models\Ledger;

class ApprovalsController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        // $recoveries = Recovery::where('status','Pending')->get();
        // $disbursements = Disbursement::where('status','Pending')->get();


        // $combined = $recoveries->concat($disbursements);

        // // Sort the combined collection by 'created_at' date
        // $sorted = $combined->sortBy('created_at');

        // // Convert the sorted collection back to an array (optional, for easier looping in views)
        // $approvals = $sorted->values()->all();
        // return view('approvals.index',compact('approvals'));

        $expenses = GeneralExpense::where('status', 'Pending')
            ->with('supplier', 'expenseItem', 'payment_method')
            ->get();

        $approvals = Payment::where('status', 'Pending')
            ->whereNull('general_expense_id')
            ->where(function ($query) {
                $query->whereNull('recovery_id') // Payments without a recovery
                    ->orWhereHas('recovery.summary', function ($q) {
                        $q->where('status', 'Closed'); // Payments with recovery's summary closed
                    });
            })
            ->get();

        // Combine the two collections into a single collection
        $combined = $expenses->concat($approvals);

        // If you need to re-index the combined collection (optional)
        $approvals = $combined->values();

        return view('approvals.index',compact('approvals'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }

    public function approve(Request $request){
        try {
            // return $request;
            \DB::beginTransaction();

            if ($request->type == "Payment") {
                $payment = Payment::find($request->id);

                if ($payment->disbursement_id) {
                    $disbursement = $payment->disbursement;
                    $disbursement->status = "Approved";
                    $disbursement->save();
                }elseif ($payment->recovery_id) {
                    $recovery = $payment->recovery;
                    $recovery->status = "Approved";
                    $recovery->save();
                }

                $payment->status = "Approved";
                $payment->save();

                $ledger = $payment->ledger;
            }else{
                $expense = GeneralExpense::find($request->id);

                $expense->status = "Approved";
                $expense->save();

                if ($expense->payment_method->type != "Credit") {
                    $payment = Payment::where('general_expense_id',$request->id)->orderBy('id','desc')->first();
                    $payment->status = "Approved";
                    $payment->save();
                }

                $ledger = Ledger::where('general_expense_id',$expense->id)->orderBy('id','desc')->first();
            }

            $ledger->status = "Approved";
            $ledger->save();

            // return $ledger;
            // $supplier_id = null;
            // $customer_id = null;

            // $disbursement_id = null;
            // $recovery_id = null;
            // if ($request->type == "recovery") {
            //     $recovery_id = $request->id;
            //     $record = Recovery::where('status','Pending')->find($request->id);

            //     if (!$record) {
            //         return redirect()->back()->withErrors(['error'=>"Unable to get recovery (ID:".$request->id.")"]);
            //     }
            //     $customer_id= $record->customer_id;

            // }

            // if ($request->type == "disbursement") {
            //     $record = Disbursement::where('status','Pending')->find($request->id);

            //     $disbursement_id = $request->id;

            //     if (!$record) {
            //         return redirect()->back()->withErrors(['error'=>"Unable to get disbursement (ID:".$request->id.")"]);
            //     }

            //     $supplier_id = $record->supplier_id;

            // }

            // $payment = new Payment;
            // $payment->supplier_id = $record->supplier_id;
            // $payment->customer_id = $record->customer_id;
            // $payment->amount = $record->amount;
            // $payment->recovery_id = $recovery_id;
            // $payment->disbursement_id = $disbursement_id;
            // $payment->reference = "Approved";
            // $payment->date = $record->date;

            // $balance = 0;

            // if ($customer_id) {
            //     $last_ledger_entry = Ledger::where('customer_id', $customer_id)->orderBy('id', 'desc')->first();
            //     if ($last_ledger_entry) {
            //         $balance = $last_ledger_entry->balance;
            //     }
            // }

            // if ($supplier_id) {
            //     $last_ledger_entry = Ledger::where('supplier_id', $supplier_id)->orderBy('id', 'desc')->first();
            //     if ($last_ledger_entry) {
            //         $balance = $last_ledger_entry->balance;
            //     }
            // }

            // $new_balance = $balance - $record->amount;

            // $payment->balance = $new_balance;

            // $payment->save();

            // $new_ledger_entry = new Ledger;
            // $new_ledger_entry->customer_id = $customer_id;
            // $new_ledger_entry->supplier_id = $supplier_id;
            // $new_ledger_entry->credit = $record->amount;
            // $new_ledger_entry->label = ucfirst($request->type);
            // $new_ledger_entry->payment_id = $payment->id;
            // $new_ledger_entry->balance = $new_balance; 
            // $new_ledger_entry->date = $payment->date;
            // $new_ledger_entry->save();

            // if ($supplier_id) {
            //     $supplier = Supplier::find($supplier_id);
            //     $supplier->balance = $new_balance;
            //     $supplier->save();
            // }

            // if ($customer_id) {
            //     $customer = Customer::find($customer_id);
            //     $customer->balance = $new_balance;
            //     $customer->save();
            // }

            // $record->status = "Approved";
            // $record->save();
            // return $request;
            \DB::commit();
            return redirect()->back()->with('success','Record has been approved successfully');
        } catch (\Throwable $e) {
            \DB::rollback();
            return redirect()->back()->withErrors(['error'=>$e->getMessage().' - '.$e->getLine()]);
        }
    }

    public function reject(Request $request){
        try{
            // $supplier_id = null;
            // $customer_id = null;
            \DB::beginTransaction();
            // if ($request->type == "recovery") {
            //     $record = Recovery::where('status','Pending')->find($request->id);

            //     if (!$record) {
            //         return redirect()->back()->withErrors(['error'=>"Unable to get recovery (ID:".$request->id.")"]);
            //     }
            //     $customer_id= $record->customer_id;

            // }

            // if ($request->type == "disbursement") {
            //     $record = Disbursement::where('status','Pending')->find($request->id);

            //     if (!$record) {
            //         return redirect()->back()->withErrors(['error'=>"Unable to get disbursement (ID:".$request->id.")"]);
            //     }

            //     $supplier_id = $record->supplier_id;

            // }

            // $record->status = "Rejected";
            // $record->save();


            $customer_id = null;
            $supplier_id = null;

            if ($request->type == "Payment") {
                $payment = Payment::find($request->id);

                $customer_id = $payment->customer_id;
                $supplier_id = $payment->supplier_id;

                if ($payment->disbursement_id) {
                    $disbursement = $payment->disbursement;
                    $disbursement->status = "Rejected";
                    $disbursement->save();
                }elseif ($payment->recovery_id) {
                    $recovery = $payment->recovery;
                    $recovery->status = "Rejected";
                    $recovery->save();
                }

                $payment->status = "Rejected";
                $payment->save();

                $ledger = $payment->ledger;
            }else{
                $expense = GeneralExpense::find($request->id);

                $supplier_id = $expense->supplier_id;

                $expense->status = "Rejected";
                $expense->save();

                if ($expense->payment_method->type != "Credit") {
                    // return $expense;
                    $payment = Payment::where('general_expense_id',$expense->id)->orderBy('id','desc')->first();
                    $payment->status = "Rejected";
                    $payment->save();
                }

                $ledger = Ledger::where('general_expense_id',$expense->id)->orderBy('id','desc')->first();
            }
            
            $ledger->status = "Rejected";
            $ledger->save();

            $restructure = new Restructure;
            if ($customer_id) {
                $restructure->customer_balances($customer_id,null);
            }

            if ($supplier_id) {
                $restructure->supplier_balances($supplier_id,null);
            }

            \DB::commit();
            return redirect()->back()->with('success','Record has been rejected!');
        }catch(\Throwable $e){
            \DB::rollback();
            return redirect()->back()->withErrors(['error'=>$e->getMessage().' - '.$e->getFile().' - '.$e->getLine()]);
        }
    }

    public function summary(Request $request){
        $approvalsSummary = new \stdClass;
        $approvalsSummary->total_sum = 0;
        $approvalsSummary->pending_sum = 0;
        $approvalsSummary->approved_sum = 0;
        $approvalsSummary->rejected_sum = 0;
        $approvalsSummary->total_count = 0;
        $approvalsSummary->pending_count = 0;
        $approvalsSummary->approved_count = 0;
        $approvalsSummary->rejected_count = 0;

        $date = date('Y-m-d');
        if ($request->date) {
            $date = $request->date;
        }

        $recoveries = Recovery::whereDate('date', $date)->get();
        $disbursements = Disbursement::whereDate('date', $date)->get();

        $combined = $recoveries->concat($disbursements);

        $sorted = $combined->sortBy('created_at');

        $approvals = $sorted->values()->all();

        // Calculate summary
        foreach ($approvals as $item) {
            $amount = $item->amount; // Assuming both Recovery and Disbursement have 'amount'

            $approvalsSummary->total_sum += $amount;
            $approvalsSummary->total_count++;

            // Assuming Recovery and Disbursement have 'status'
            if (isset($item->status)) {
                if ($item->status == 'Approved') {
                    $approvalsSummary->approved_sum += $amount;
                    $approvalsSummary->approved_count++;
                } elseif ($item->status == 'Pending') {
                    $approvalsSummary->pending_sum += $amount;
                    $approvalsSummary->pending_count++;
                } elseif ($item->status == 'Rejected') {
                    $approvalsSummary->rejected_sum += $amount;
                    $approvalsSummary->rejected_count++;
                }
            }
        }

        return view('approvals.summary', compact('approvals', 'approvalsSummary'));

    }
}
