<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Approval;
use App\Models\User;
use App\Models\ApprovalStep;
use App\Models\ApprovalSetting;
use App\Models\InventoryStock;

class ApprovalsController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $approvals = Approval::query()->business();

        if (!!$request->trashed) {
            $approvals->withTrashed();
        }

        if(!empty($request->search)) {
            $approvals->where('module', 'like', '%' . $request->search . '%');
        }

        if (!empty($request->module)) {
            $approvals->where('module',$request->module);

            $approvals = $approvals->orderBy('order_no','asc')->get();

            foreach ($approvals as $approval) {
                $userIds = json_decode($approval->users);
                $approval->users_list = User::whereIn('id', $userIds)->get();
            }

            $module = $request->module;

            return view('settings.approvals.show', compact('approvals','module'));
        }else{
            $approvals = $approvals->get();

            return view('settings.approvals.index', compact('approvals'));
        }
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create(Request $request)
    {
        $module = $request->module;
        $users = User::business()->select('id','name','email')->get();
        return view('settings.approvals.create',compact('module','users'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'label' => 'required',
            'users' => 'required',
            'module' => 'required',
        ]);

        try{

            $order_no = Approval::business()->where('module',$request->module)->count();

            $approval = new Approval;
            $approval->business_id = \Auth::user()->business_id;
            $approval->module = $request->module;
            $approval->name = $request->name;
            $approval->label = $request->label;
            $approval->order_no = $order_no;
            $approval->condition = 1;
            $approval->show_on_pdf = !!$request->show_on_pdf;
            $approval->users = json_encode($request->users);
            $approval->status = $request->status;
            $approval->save();

            return redirect('approvals?module='.$approval->module)->with('success','Approval has been saved successfully!');

        }catch(\Throwable $ex){
            return redirect()->back()->withErrors(['error'=>$ex->getMessage()])->withInput();
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $approval = Approval::find($id);

        $users = User::business()->select('id','name','email')->get();

        return view('settings.approvals.edit',compact('approval','users'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        
        $request->validate([
            'name' => 'required',
            'label' => 'required',
            'users' => 'required',
            'module' => 'required',
        ]);

        try{

            // $order_no = Approval::business()->where('module',$request->module)->count();

            $approval = Approval::find($id);
            $approval->business_id = \Auth::user()->business_id;
            $approval->module = $request->module;
            $approval->name = $request->name;
            $approval->label = $request->label;
            // $approval->order_no = $order_no;
            $approval->condition = 1;
            $approval->show_on_pdf = !!$request->show_on_pdf;
            $approval->users = json_encode($request->users);
            $approval->status = $request->status;
            $approval->save();

            return redirect('approvals?module='.$approval->module)->with('success','Approval has been updaeted successfully!');

        }catch(\Throwable $ex){
            return redirect()->back()->withErrors(['error'=>$ex->getMessage()])->withInput();
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }

    public function order(Request $request)
    {
        $post = $request->all();

        foreach($post['order'] as $key => $item)
        {
            $approval = Approval::business()->where('module',$request->module)->where('id', '=', $item)->first();
            $approval->order_no = $key;
            $approval->save();
        }
    }

    public function processApprovalView($id)
    {
        $approval_step = ApprovalStep::business()->find($id);

        $approval = new \stdClass;
        $approval->id = $id;

        if ($approval_step->invoice_id) {
            $approval->type = $approval_step->invoice->type;
            $approval->no = $approval_step->invoice->invoice_no;
        }else if ($approval_step->requisition_id) {
            $approval->type = "Requisition No";
            $approval->no = $approval_step->requisition?->requisition_no;
        }else if ($approval_step->leave_id) {
            $approval->type = "Leave";
            $approval->no = $approval_step->leave?->application_no;
        }else{
            $approval->type = "Load BOM";
            $approval->no = $approval_step->load_bom?->load_bom_no;
        }

        return view('settings.approvals.process',compact('approval'));
    }

    public function processRequest(Request $request)
    {
        $request->validate([
            'id' => 'required|integer',
            'action' => 'required|string|in:Approved,Rejected',
            'comment' => 'nullable|string'
        ]);

        if ($request->action === 'Reject') {
            $request->validate([
                'comment' => 'required|string'
            ]);
        }

        try{
            \DB::beginTransaction();
            $approvalStep = ApprovalStep::business()->find($request->id);

            $approvalStep->status = $request->action;
            $approvalStep->comment = $request->comment;
            $approvalStep->save();

            $email = \Auth::user()->email;

            if ($approvalStep->invoice_id) {

                if ($request->comment) {
                    $comment = new \App\Models\Comment;
                    $comment->business_id = $approvalStep->business_id;
                    $comment->comment = $request->comment;
                    $comment->invoice_id = $approvalStep->invoice_id;
                    $comment->approval_id = $approvalStep->approval_id;
                    $comment->user_id = \Auth::user()->id;
                    $comment->save();
                }

                $invoice = $approvalStep->invoice;

                ApprovalStep::where('approval_id', $approvalStep->approval_id)
                        ->where('invoice_id', $approvalStep->invoice_id)
                        ->where('id', '!=', $approvalStep->id)
                        ->update(['status' => 'Passed']);

                if ($approvalStep->status == "Approved") {
                    $nextApprovalStep = ApprovalStep::where('id', '>', $approvalStep->id)
                        ->where('invoice_id', $approvalStep->invoice_id)
                        ->where('approval_id','!=',$approvalStep->approval_id)
                        ->first();

                    if ($nextApprovalStep) {
                        ApprovalStep::where('approval_id', $nextApprovalStep->approval_id)
                            ->where('invoice_id', $nextApprovalStep->invoice_id)
                            ->update(['status' => 'Pending']);

                        $invoice->approval_id = $nextApprovalStep->approval_id;
                    }else{

                        $invoice->approval_status = "Approved";
                    }
                    $invoice->save();
                }

                $email = $invoice->user?->email;
                
            }

            if ($approvalStep->load_bom_id) {

                if ($request->comment) {
                    $comment = new \App\Models\Comment;
                    $comment->business_id = $approvalStep->business_id;
                    $comment->comment = $request->comment;
                    $comment->load_bom_id = $approvalStep->load_bom_id;
                    $comment->approval_id = $approvalStep->approval_id;
                    $comment->user_id = \Auth::user()->id;
                    $comment->save();
                }

                $bom = $approvalStep->load_bom;

                ApprovalStep::where('approval_id', $approvalStep->approval_id)
                        ->where('load_bom_id', $approvalStep->load_bom_id)
                        ->where('id', '!=', $approvalStep->id)
                        ->update(['status' => 'Passed']);

                if ($approvalStep->status == "Approved") {
                    $nextApprovalStep = ApprovalStep::where('id', '>', $approvalStep->id)
                        ->where('load_bom_id', $approvalStep->load_bom_id)
                        ->where('approval_id','!=',$approvalStep->approval_id)
                        ->first();

                    if ($nextApprovalStep) {
                        ApprovalStep::where('approval_id', $nextApprovalStep->approval_id)
                            ->where('load_bom_id', $nextApprovalStep->load_bom_id)
                            ->update(['status' => 'Pending']);

                        $bom->approval_id = $nextApprovalStep->approval_id;
                    }else{

                        $bom->status = "Approved";
                    }
                    $bom->save();
                }

                
            }

            if ($approvalStep->requisition_id) {

                if ($request->comment) {
                    $comment = new \App\Models\Comment;
                    $comment->business_id = $approvalStep->business_id;
                    $comment->comment = $request->comment;
                    $comment->requisition_id = $approvalStep->requisition_id;
                    $comment->approval_id = $approvalStep->approval_id;
                    $comment->user_id = \Auth::user()->id;
                    $comment->save();
                }

                $requisition = $approvalStep->requisition;

                ApprovalStep::where('approval_id', $approvalStep->approval_id)
                        ->where('requisition_id', $approvalStep->requisition_id)
                        ->where('id', '!=', $approvalStep->id)
                        ->update(['status' => 'Passed']);

                if ($approvalStep->status == "Approved") {
                    $nextApprovalStep = ApprovalStep::where('id', '>', $approvalStep->id)
                        ->where('requisition_id', $approvalStep->requisition_id)
                        ->where('approval_id','!=',$approvalStep->approval_id)
                        ->first();

                    if ($nextApprovalStep) {
                        ApprovalStep::where('approval_id', $nextApprovalStep->approval_id)
                            ->where('requisition_id', $nextApprovalStep->load_bom_id)
                            ->update(['status' => 'Pending']);

                        $requisition->approval_id = $nextApprovalStep->approval_id;
                    }else{

                        $requisition->status = "Complete";

                        if ($requisition->type == "Departmental") {
                            $response = $this->manuplateDepartmentalStock($requisition);

                            if ($response->code != "00") {
                                \DB::rollback();
                                return redirect()->back()->withErrors(['error'=>$response->message])->withInput();
                            }
                        }
                    }
                    $requisition->save();
                }

                $email = $requisition->user->email;
            }


            if ($approvalStep->leave_id) {

                // if ($request->comment) {
                //     $comment = new \App\Models\Comment;
                //     $comment->business_id = $approvalStep->business_id;
                //     $comment->comment = $request->comment;
                //     $comment->requisition_id = $approvalStep->requisition_id;
                //     $comment->approval_id = $approvalStep->approval_id;
                //     $comment->user_id = \Auth::user()->id;
                //     $comment->save();
                // }

                $leave = $approvalStep->leave;

                ApprovalStep::where('approval_id', $approvalStep->approval_id)
                        ->where('leave_id', $approvalStep->leave_id)
                        ->where('id', '!=', $approvalStep->id)
                        ->update(['status' => 'Passed']);

                if ($approvalStep->status == "Approved") {
                    $nextApprovalStep = ApprovalStep::where('id', '>', $approvalStep->id)
                        ->where('leave_id', $approvalStep->leave_id)
                        ->where('approval_id','!=',$approvalStep->approval_id)
                        ->first();

                    if ($nextApprovalStep) {
                        ApprovalStep::where('approval_id', $nextApprovalStep->approval_id)
                            ->where('leave_id', $nextApprovalStep->leave_id)
                            ->update(['status' => 'Pending']);

                        $leave->approval_id = $nextApprovalStep->approval_id;
                    }else{

                        $leave->status = "Complete";

                        // if ($requisition->type == "Departmental") {
                        //     $response = $this->manuplateDepartmentalStock($requisition);

                        //     if ($response->code != "00") {
                        //         \DB::rollback();
                        //         return redirect()->back()->withErrors(['error'=>$response->message])->withInput();
                        //     }
                        // }
                    }
                    $leave->save();
                }else{
                    $leave->status = "Rejected";
                    $leave->save();
                }

                // $email = $leave->user->email;
            }

            \DB::commit();

            // \Mail::to("musisifred7@gmail.com")->bcc($email)->send(new \App\Mail\ApprovalRequest("Processed",'',$request->comment));

            return redirect()->back()->with('success','Request has been '.$request->action.' successfully!');
        }catch(\Throwable $ex){
            return redirect()->back()->withErrors(['error'=>$ex->getMessage().' on line '.$ex->getLine()])->withInput();
        }
    }

    public function manuplateDepartmentalStock($requisition)
    {

        $response = new \stdClass;
        $response->code = "00";
        $response->message = "success";

        foreach ($requisition->items as $item) {

            $available_stock = InventoryStock::where('store_id',$requisition->store_id)
                                                ->where('inventory_id',$item->inventory_id)
                                                ->orderBy('id','desc')
                                                ->first();
            if (!$available_stock) {
                $response->code = "01";
                $response->message = $requisition->store?->name." does not have enough stock for item ".$item->name."!";
                return $response;
            }

            if (($available_stock->balance - $item->quantity) < 0) {
                $response->code = "01";
                $response->message = $requisition->store?->name." does not have enough stock for item ".$item->name."!";
                return $response;
            }

            $stock = new InventoryStock;
            $stock->business_id = \Auth::user()->business_id;
            $stock->inventory_id = $item->inventory_id;
            $stock->tid = \Str::uuid();
            $stock->type = "Departmental Requisition";
            $stock->store_id = $requisition->store_id;
            $stock->balance = $available_stock->balance - $item->quantity;
            $stock->quantity = $item->quantity;
            $stock->requisition_item_id = $item->id;
            $stock->requisition_id = $requisition->id;
            $stock->save(); 
        }

        return $response;
    }

    public function getSettings()
    {
        $approvalSetting = ApprovalSetting::where('business_id',\Auth::user()->business_id)->first();

        if (!$approvalSetting) {
            $approvalSetting = new ApprovalSetting;
            $approvalSetting->business_id = \Auth::user()->business_id;
            $approvalSetting->save();
        }
        return view('settings.approvals.settings',compact('approvalSetting'));
    }

    public function updateSettings(Request $request)
    {
        $approvalSetting = ApprovalSetting::where('business_id',\Auth::user()->business_id)->first();

        // Update the approval settings
        $approvalSetting->update([
            'invoices_approval' => $request->has('invoices_approval') ? 1 : 0,
            'quotations_approval' => $request->has('quotations_approval') ? 1 : 0,
            'proformas_approval' => $request->has('proformas_approval') ? 1 : 0,
            'sales_orders_approval' => $request->has('sales_orders_approval') ? 1 : 0,
            'load_boms_approval' => $request->has('load_boms_approval') ? 1 : 0,
            'boms_approval' => $request->has('boms_approval') ? 1 : 0,
            'expenses_approval' => $request->has('expenses_approval') ? 1 : 0,
            'credit_notes_approval' => $request->has('credit_notes_approval') ? 1 : 0,
            'payroll_approval' => $request->has('payroll_approval') ? 1 : 0,
            'leave_approval' => $request->has('leave_approval') ? 1 : 0,
        ]);

        return redirect()->back()->with('success','Approval Settings have been updated successfully');
    }
}
