<?php
namespace App\Helpers;
/**
 * 
 */
use App\Models\Ledger;
use App\Models\Credit;
use App\Models\Collection;
use App\Models\Intake;
use App\Models\Payment;
use App\Models\Customer;
use App\Models\Supplier;
use App\Models\SuspenseAccount;
use App\Models\Summary;

class Restructure
{
	
	function __construct()
	{
		// code...
	}

	// public function customer_balances($customer_id,$opening_balance = null)
	// {
	// 	// Start with an initial balance (could be opening balance or zero)

	// 	$runningBalance = ($opening_balance == null) ? 0:$opening_balance;
	// 	if ($opening_balance == null) {
	// 		$balance = Ledger::where('customer_id',$customer_id)->orderBy('id','desc')->first();

	// 		if ($balance) {
	// 			$runningBalance = $balance->amount;
	// 		}else{
	// 			$runningBalance = 0;
	// 		}
	// 	}

    // // Fetch all transactions (credits, collections, and payments) ordered by date
	// 	$credits = Credit::where('customer_id', $customer_id)->get();
	// 	$collections = Collection::where('customer_id', $customer_id)->get();
	// 	$payments = Payment::where('customer_id', $customer_id)->get();

    // // Merge all transactions into one collection and order by date
	// 	$transactions = collect();

    // // Add Credits to transactions
	// 	foreach ($credits as $credit) {
	// 		$transactions->push([
	// 			'date' => $credit->date,
	// 			'label' => 'Credit',
	// 			'credit' => $credit->amount,
	// 			'debit' => 0,
	// 		]);
	// 	}

    // // Add Collections to transactions
	// 	foreach ($collections as $collection) {
	// 		$transactions->push([
	// 			'date' => $collection->date,
	// 			'label' => 'Collection',
	// 			'credit' => 0,
    //         'debit' => $collection->amount, // Money taken by the customer
    //     ]);
	// 	}

    // // Add Payments to transactions
	// 	foreach ($payments as $payment) {
	// 		$transactions->push([
	// 			'date' => $payment->date,
	// 			'label' => 'Payment',
	// 			'credit' => 0,
    //         'debit' => $payment->amount, // Money paid by the customer
    //     ]);
	// 	}

    // // Order the transactions by date
	// 	$transactions = $transactions->sortBy('date');

    // // Insert into Ledger and update running balance
	// 	foreach ($transactions as $transaction) {
	// 		$runningBalance += $transaction['credit'] - $transaction['debit'];

    //     // Create the ledger record
	// 		Ledger::create([
	// 			'customer_id' => $customer_id,
	// 			'date' => $transaction['date'],
	// 			'label' => $transaction['label'],
	// 			'credit' => $transaction['credit'],
	// 			'debit' => $transaction['debit'],
    //         'balance' => $runningBalance, // Maintain running balance
    //     ]);
	// 	}

	// }
	public function customer_balances($customer_id, $opening_balance = null)
	{
		Ledger::where('customer_id', $customer_id)
			->where('label', '!=', 'Opening balance')
			->delete();

		$openingBalanceEntry = Ledger::where('customer_id', $customer_id)
			->where('label', 'Opening balance')
			->orderBy('id','desc')
			->first();

		if ($openingBalanceEntry && $opening_balance != null) {
			$openingBalanceEntry->debit = $opening_balance;
			$openingBalanceEntry->balance = $opening_balance;
			$openingBalanceEntry->save();
		} else {
			if (!$openingBalanceEntry) {
				Ledger::create([
					'customer_id' => $customer_id,
	                'date' => "2024-08-12",
	                'label' => 'Opening balance',
	                'credit' => 0,
	                'debit' => (($opening_balance)?$opening_balance:0),
	                'balance' => (($opening_balance)?$opening_balance:0),
	                'recovery_id' => null,
	                'status' => 'Approved',
	            ]);
			}
		}
    	// Step 2: Start with the updated or existing opening balance
		$runningBalance = Ledger::where('customer_id', $customer_id)
		->where('label', 'Opening balance')
		->value('balance');

    	// Step 3: Fetch all transactions (credits, collections, and payments) ordered by date
		$credits = Credit::where('customer_id', $customer_id)
					->whereHas('summary', function ($query) {
			            $query->where('status', 'Closed');
			        })->get();
		$collections = Collection::where('customer_id', $customer_id)
					->whereHas('summary', function ($query) {
			            $query->where('status', 'Closed');
			        })->get();
		$payments = Payment::where('customer_id', $customer_id)->where('status','!=','Rejected')->get();

    	// Step 4: Merge all transactions into one collection and order by date
		$transactions = collect();

    	// Add Credits to transactions
		foreach ($credits as $credit) {
			$transactions->push([
				'date' => $credit->date,
				'label' => 'Credit',
				'credit_id' => $credit->id,
				'credit' => 0,
				'collection_id' => null,
				'suspense_account_id' => null,
				'recovery_id' => null,
				'payment_id' => null,
				'debit' => $credit->amount,
				'status' => 'Approved',
			]);
		}

   	 	// Add Collections to transactions
		foreach ($collections as $collection) {
			$transactions->push([
				'date' => $collection->date,
				'label' => 'Collection',
				'credit' => 0,
				'payment_id' => null,
				'credit_id' => null,
				'suspense_account_id' => null,
				'recovery_id' => null,
				'collection_id' => $collection->id,
            	'debit' => $collection->amount, // Money taken by the customer
            	'status' => 'Approved'
        	]);
		}

    	// Add Payments to transactions
		foreach ($payments as $payment) {
			$transactions->push([
				'date' => $payment->date,
				'label' => ($payment->recovery_id)?"Recovery":"Payment",
				'debit' => 0,
				'payment_id' => $payment->id,
				'recovery_id' => ($payment->recovery_id) ?:null,
				'collection_id' => null,
				'suspense_account_id' => null,
				'credit_id' => null,
            	'credit' => $payment->amount, // Money paid by the customer
            	'status' => $payment->status,
        	]);
		}

		$suspense_balances = SuspenseAccount::where('customer_id', $customer_id)->get();

		foreach ($suspense_balances as $balance) {
			$transactions->push([
				'date' => date('Y-m-d',strtotime($balance->created_at)),
				'label' => "Credit Transfer",
				'debit' => ($balance->type == "In") ? $balance->amount:null,
				'suspense_account_id' => $balance->id,
				'payment_id' => null,
				'recovery_id' => null,
				'collection_id' => null,
				'credit_id' => null,
            	'credit' => ($balance->type == "Out") ? $balance->amount:null,
            	'status' => 'Approved',
        	]);
		}

    	// Step 5: Order the transactions by date
		$transactions = $transactions->sortBy('date');

		// dd($transactions);

    	// Step 6: Insert into Ledger and update running balance
		foreach ($transactions as $transaction) {
			$runningBalance += (($transaction['debit'])?:0) - (($transaction['credit'])?:0);

        	// Create the ledger record
			Ledger::create([
				'customer_id' => $customer_id,
				'date' => $transaction['date'],
				'label' => $transaction['label'],
				'credit' => (($transaction['credit'])?:0),
				'debit' => (($transaction['debit'])?:0),
				'credit_id' => $transaction['credit_id'],
				'suspense_account_id' => $transaction['suspense_account_id'],
				'collection_id' => $transaction['collection_id'],
				'recovery_id' => $transaction['recovery_id'],
				'payment_id' => $transaction['payment_id'],
            	'balance' => $runningBalance, // Maintain running balance
            	'status' => $transaction['status'],
        	]);
		}

		$customer = Customer::find($customer_id);
		$customer->balance = $runningBalance;
		$customer->save();

		return "Ledger populated for customer_id: $customer_id with opening balance: $opening_balance";
	}

	public function supplier_balances($supplier_id, $opening_balance = null)
	{
		Ledger::where('supplier_id', $supplier_id)
			->where('label', '!=', 'Opening balance')
			->delete();

		$openingBalanceEntry = Ledger::where('supplier_id', $supplier_id)
			->where('label', 'Opening balance')
			->orderBy('id','desc')
			->first();

		if ($openingBalanceEntry && $opening_balance != null) {
			$openingBalanceEntry->debit = $opening_balance;
			$openingBalanceEntry->balance = $opening_balance;
			$openingBalanceEntry->save();
		} else {
			if (!$openingBalanceEntry) {
				Ledger::create([
					'supplier_id' => $supplier_id,
	                'date' => "2024-08-12",
	                'label' => 'Opening balance',
	                'credit' => 0,
	                'debit' => (($opening_balance)?$opening_balance:0),
	                'balance' => (($opening_balance)?$opening_balance:0),
	                'status' => 'Approved',
	            ]);
			}
		}
    	// Step 2: Start with the updated or existing opening balance
		$runningBalance = Ledger::where('supplier_id', $supplier_id)
		->where('label', 'Opening balance')
		->value('balance');

    	// Step 3: Fetch all transactions (credits, collections, and payments) ordered by date
		$intakes = Intake::where('supplier_id', $supplier_id)
					->whereHas('summary', function ($query) {
			            $query->where('status', 'Closed');
			        })->get();
		// $collections = Collection::where('customer_id', $customer_id)
		// 			->whereHas('summary', function ($query) {
		// 	            $query->where('status', 'Closed');
		// 	        })->get();
		$payments = Payment::where('supplier_id', $supplier_id)->where('status','!=','Rejected')->get();

    	// Step 4: Merge all transactions into one collection and order by date
		$transactions = collect();

    	// Add Credits to transactions
		foreach ($intakes as $intake) {
			$transactions->push([
				'date' => $intake->date,
				'label' => 'Purchase',
				'intake_id' => $intake->id,
				'credit' => 0,
				'collection_id' => null,
				'general_expense_id' => null,
				'payment_id' => null,
				'debit' => $intake->quantity * $intake->supplier_rate,
				'status' => 'Approved',
			]);
		}

		$purchases = \App\Models\Purchase::where('supplier_id',$supplier_id)->where('status','Approved')->withSum('items','total')->get();
		// dd($purchases->toArray());
		foreach ($purchases as $purchase) {
			$transactions->push([
				'date' => $purchase->date,
				'label' => 'Direct Purchase',
				'purchase_id' => $purchase->id,
				'credit' => 0,
				'general_expense_id' => null,
				'collection_id' => null,
				'payment_id' => null,
				'debit' => $purchase->items_sum_total,
				'status' => 'Approved',
			]);
		}

		$GeneralExpenses = \App\Models\GeneralExpense::where('supplier_id',$supplier_id)->get();
		// dd($GeneralExpenses->toArray());
		foreach ($GeneralExpenses as $expense) {
			// dd($expense->amount);
			$transactions->push([
				'date' => $expense->expense_date,
				'label' => 'General Expense',
				'general_expense_id' => $expense->id,
				'credit' => 0,
				'collection_id' => null,
				'payment_id' => null,
				'debit' => $expense->amount,
				'status' => $expense->status,
			]);
		}

   	 	// // Add Collections to transactions
		// foreach ($collections as $collection) {
		// 	$transactions->push([
		// 		'date' => $collection->date,
		// 		'label' => 'Collection',
		// 		'credit' => 0,
		// 		'payment_id' => null,
		// 		'credit_id' => null,
		// 		'collection_id' => $collection->id,
        //     	'debit' => $collection->amount, // Money taken by the customer
        // 	]);
		// }

    	// Add Payments to transactions
		foreach ($payments as $payment) {
			$transactions->push([
				'date' => $payment->date,
				'label' => 'Payment',
				'debit' => 0,
				'payment_id' => $payment->id,
				'collection_id' => null,
				'credit_id' => null,
				'general_expense_id' => null,
            	'credit' => $payment->amount, // Money paid by the customer
            	'status' => $payment->status,
        	]);
		}

    	// Step 5: Order the transactions by date
		$transactions = $transactions->sortBy('date');

		// dd($transactions);

    	// Step 6: Insert into Ledger and update running balance
		foreach ($transactions as $transaction) {
			$runningBalance += (($transaction['debit'])?:0) - (($transaction['credit'])?:0);

        	// Create the ledger record
			Ledger::create([
				'supplier_id' => $supplier_id,
				'date' => $transaction['date'],
				'label' => $transaction['label'],
				'credit' => (($transaction['credit'])?:0),
				'debit' => (($transaction['debit'])?:0),
				'general_expense_id' => $transaction['general_expense_id'],
				'collection_id' => $transaction['collection_id'],
				'payment_id' => $transaction['payment_id'],
            	'balance' => $runningBalance, // Maintain running balance
            	'status' => $transaction['status'],
        	]);
		}

		$customer = Supplier::find($supplier_id);
		$customer->balance = $runningBalance;
		$customer->save();

		return "Ledger populated for customer_id: $supplier_id with opening balance: $opening_balance";
	}


	public function branch_balances($branch_id,$summary_id = null)
	{
		$summaries = Summary::query()->where('branch_id',$branch_id);

		if ($summary_id) {
			$summary = Summary::find($summary_id);
			$summaries->whereDate('date','>=',$summary->date);
		}

		$summaries->withSum('collections','amount');
		$summaries->withSum('credits','amount');
		$summaries->withSum('summary_expenses','amount');
		$summaries->withSum('summary_discounts','total_discount');
		$summaries->withSum('intakes','amount');
		$summaries->withSum('profits','amount');
		$summaries->withSum('summary_transfers','amount');

		$summaries = $summaries->orderBy('date','asc')->get();

		$opening_balance = 0;
		foreach ($summaries as $index => $summary) {
			if ($index == 0) {
				$opening_balance = $summary->opening_balance;
			}

			$cash_sales = ($summary->collections_sum_amount)?:0;
			$credit_sales = ($summary->credits_sum_amount)?:0;
			$expenses = ($summary->summary_expenses_sum_amount)?:0;
			$discounts = ($summary->summary_discounts_sum_total_discount)?:0;
			$intakes = ($summary->intakes_sum_amount)?:0;
			$profits = ($summary->profits_sum_amount)?:0;
			$transfers = ($summary->summary_transfers_sum_amount)?:0;

			$summary->opening_balance = $opening_balance;
			$summary->expenses = $expenses;
			$summary->discounts = $discounts;
			$summary->credit_sales = $credit_sales;
			$summary->cash_sales = $cash_sales;
			$summary->total_sales = $cash_sales + $credit_sales + $expenses + $discounts;
			$summary->intake = $intakes;
			$summary->profits_total = $profits;
			$summary->transfers = $transfers;
			$summary->closing_balance = $summary->opening_balance + $summary->intake + $summary->profits_total - ($summary->total_sales + $summary->transfers);
			$summary->save();

			$opening_balance = $summary->closing_balance;
		}

		return $summaries;
	}
}