<?php $__env->startSection('content'); ?>
<div class="card">
	<div class="card-body">
		<form class="row">
			<div class="col-md-3">
				<label>Start Date</label>
				<input type="date" name="start_date" class="form-control" value="<?php echo e(($request->start_date) ? $request->start_date : date('Y-m-d')); ?>" data-provider="flatpickr" >
			</div>
			<div class="col-md-3">
				<label>End Date</label>
				<input type="date" name="end_date" class="form-control" value="<?php echo e(($request->end_date) ? $request->end_date : date('Y-m-d')); ?>" data-provider="flatpickr" >
			</div>
			<div class="col-md-3">
				<label>Customer</label>
				<select class="form-select select2" name="customer" required>
					<?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<option value="<?php echo e($customer->id); ?>" <?php echo e(($request->customer) ? (($customer->id == $request->customer) ? 'selected':'') : ''); ?>><?php echo e($customer->name); ?></option>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				</select>
			</div>
			<div class="col-md-3">
				<label></label>
				<button type="submit" class="btn btn-primary">Search</button>
				<button type="submit" class="btn btn-warning" name="download" value="pdf">PDF</button>
			</div>
		</form>
	</div>
</div>
<div class="card">
        <div class="card-header d-flex flex-column flex-md-row align-items-md-center justify-content-between">
            <h5>Customer Ledger</h5>
        </div>
        <div class="table-responsive card-body">
            <table class="table table-striped table-hover table-bordered ">
                <thead role="rowgroup bg-light">
                    <tr role="row">
                        <th role='columnheader'>Date</th>
                        <th role='columnheader'>Type</th>
                        <th role='columnheader'>Credit</th>
                        <th role='columnheader'>Debit</th>
                        <th role='columnheader'>Balance</th> 
                    </tr>
                </thead>
                <tbody>
                	<tr>
                		<td colspan="4"><i>Balance B/F</i></td>
                		<td><?php echo e($balance); ?></td>
                	</tr>
                    <?php $__currentLoopData = $entries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $entry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e(date('d M, Y',strtotime($entry->date))); ?></td>
                        <td data-label="Type"><?php echo e($entry->reference ?: "-"); ?></td>
                        <td data-label="Payment_Method"><?php echo e($entry->credit ?: "-"); ?></td>
                        <td data-label="Gross Amount"><?php echo e($entry->debit ?: "-"); ?></td>
                        <td data-label="Sales Person"><?php echo e($entry->balance ?: "-"); ?></td>
                	</tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u380932374/domains/wykaconsults.com/public_html/subdomains/admin/resources/views/reports/customer_ledger.blade.php ENDPATH**/ ?>