<?php $__env->startSection('paymentMethods.content'); ?>
<div class="container">
    <div class="card">
        <div class="card-header d-flex flex-column flex-md-row align-items-md-center justify-content-between">
            <ol class="breadcrumb m-0 p-0 flex-grow-1 mb-2 mb-md-0">
                <li class="breadcrumb-item"><a href="<?php echo e(implode('/', ['','payment_methods'])); ?>"> Payment Methods</a></li>
            </ol>

            <form action="<?php echo e(route('payment_methods.index', [])); ?>" method="GET" class="m-0 p-0">
                <div class="input-group">
                    <input type="text" class="form-control form-control-sm me-2" name="search" placeholder="Search Payment Methods..." value="<?php echo e(request()->search); ?>">
                    <span class="input-group-btn">
                        <button class="btn btn-info btn-sm" type="submit"><i class="fa fa-search"></i> <?php echo app('translator')->get('Go!'); ?></button>
                    </span>
                </div>
            </form>
        </div>
        <div class="card-body">
            <table class="table table-striped table-responsive table-hover">
                <thead role="rowgroup">
                    <tr role="row">
                        <th role='columnheader'>Name</th>
                        <th role='columnheader'>Type</th>
                        <th scope="col" data-label="Actions">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $paymentMethods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $paymentMethod): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td data-label="Name"><?php echo e($paymentMethod->name ?: "(blank)"); ?></td>
                        <td data-label="Type"><?php echo e($paymentMethod->type ?: "(blank)"); ?></td>

                        <td data-label="Actions:" class="text-nowrap">
                         <?php if($paymentMethod->trashed()): ?>
                         <form action="<?php echo e(route('payment_methods.restore', ['paymentMethod' => $paymentMethod])); ?>" method="POST" class="d-inline-block me-2">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>
                            <input type="submit" name="restore" value="<?php echo app('translator')->get('Restore'); ?>" class="btn btn-success btn-sm"/>
                        </form>
                        <form action="<?php echo e(route('payment_methods.purge', ['paymentMethod' => $paymentMethod])); ?>" method="POST" class="d-inline-block">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <input type="submit" name="purge" value="<?php echo app('translator')->get('Purge'); ?>" class="btn btn-danger btn-sm"/>
                        </form>
                        <?php else: ?>
                        <a href="<?php echo e(route('payment_methods.show', $paymentMethod->id)); ?>" type="button" class="btn btn-primary btn-sm me-1"><?php echo app('translator')->get('Show'); ?></a>
                        <div class="btn-group btn-group-sm">
                            <button type="button" class="btn btn-light dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false"><i class="fa fa-cog"></i></button>
                            <ul class="dropdown-menu">
                                <li><a class="dropdown-item" href="<?php echo e(route('payment_methods.edit', $paymentMethod->id)); ?>"><?php echo app('translator')->get('Edit'); ?></a></li>
                                <li>
                                    <form action="<?php echo e(route('payment_methods.destroy', $paymentMethod->id)); ?>" method="POST" style="display: inline;" class="m-0 p-0">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="dropdown-item"><?php echo app('translator')->get('Delete'); ?></button>
                                    </form>
                                </li>
                            </ul>
                        </div>

                        <?php endif; ?>

                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>

        <?php echo e($paymentMethods->withQueryString()->links()); ?>

    </div>
    <div class="text-center my-2">
        <a href="<?php echo e(route('payment_methods.create', [])); ?>" class="btn btn-primary"><i class="fa fa-plus"></i> <?php echo app('translator')->get('Create new Payment Method'); ?></a>
    </div>
</div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('payment_methods.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u380932374/domains/wykaconsults.com/public_html/subdomains/admin/resources/views/payment_methods/index.blade.php ENDPATH**/ ?>