<?php $__env->startSection('expenses.content'); ?>
<div class="container">
    <div class="card">
        <div class="card-header d-flex flex-row align-items-center justify-content-between">
            <ol class="breadcrumb m-0 p-0">
                <li class="breadcrumb-item"><a href="<?php echo e(implode('/', ['','expenses'])); ?>"> Expenses</a></li>
                <li class="breadcrumb-item"><?php echo app('translator')->get('Create new'); ?></li>
            </ol>
        </div>

        <div class="card-body">
            <form action="<?php echo e(route('expenses.store', [])); ?>" method="POST" class="m-0 p-0">
                <div class="card-body row">
                    <?php echo csrf_field(); ?>
                    <div class="mb-3 col-md-6">
                        <label for="expense_item_id" class="form-label">Expense Item:</label>
                        <div class="d-flex flex-row align-items-center justify-content-between">
                            <select name="expense_item_id" id="expense_item_id" class="form-control form-select flex-grow-1" required>
                                <option value="" selected disabled>Select Expense Item</option>
                                <?php $__currentLoopData = $expenseItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $expenseItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($expenseItem->id); ?>" <?php echo e(@old('expense_item_id') == $expenseItem->id ? "selected" : ""); ?>><?php echo e($expenseItem->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>

                            <a class="btn btn-light text-nowrap" href="<?php echo e(url('expense_items/create')); ?>"><i class="fa fa-plus-circle"></i> New</a>
                        </div>
                        <?php if($errors->has('expense_item_id')): ?>
                        <div class='error small text-danger'><?php echo e($errors->first('expense_item_id')); ?></div>
                        <?php endif; ?>
                    </div>
                    <div class="mb-3 col-md-6">
                        <label for="payment_method_id" class="form-label">Payment Method:</label>
                        <div class="d-flex flex-row align-items-center justify-content-between">
                            <select name="payment_method_id" id="payment_method_id" class="form-control form-select flex-grow-1" required>
                                <option value="" selected disabled>Select Payment Method</option>
                                <?php $__currentLoopData = $paymentMethods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $paymentMethod): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($paymentMethod->id); ?>" <?php echo e(@old('payment_method_id') == $paymentMethod->id ? "selected" : ""); ?>><?php echo e($paymentMethod->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>

                            <a class="btn btn-light text-nowrap" href="<?php echo e(url('payment_methods/create')); ?>"><i class="fa fa-plus-circle"></i> New</a>
                        </div>
                        <?php if($errors->has('payment_method_id')): ?>
                        <div class='error small text-danger'><?php echo e($errors->first('payment_method_id')); ?></div>
                        <?php endif; ?>
                    </div>
                    <div class="mb-3 col-md-6">
                        <label for="expense_date" class="form-label">Expense Date:</label>
                        <input type="date" name="expense_date" id="expense_date" class="form-control" value="<?php echo e(@old('expense_date')); ?>" required/>
                        <?php if($errors->has('expense_date')): ?>
                        <div class='error small text-danger'><?php echo e($errors->first('expense_date')); ?></div>
                        <?php endif; ?>
                    </div>
                    <div class="mb-3 col-md-6">
                        <label for="amount" class="form-label">Amount:</label>
                        <input type="text" name="amount" id="amount" class="form-control number_format" value="<?php echo e(@old('amount')); ?>" required/>
                        <?php if($errors->has('amount')): ?>
                        <div class='error small text-danger'><?php echo e($errors->first('amount')); ?></div>
                        <?php endif; ?>
                    </div>

                </div>

                <div class="card-footer">
                    <div class="d-flex flex-row align-items-center justify-content-between">
                        <a href="<?php echo e(route('expenses.index', [])); ?>" class="btn btn-light"><?php echo app('translator')->get('Cancel'); ?></a>
                        <button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Create new Expense'); ?></button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('expenses.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u380932374/domains/wykaconsults.com/public_html/subdomains/admin/resources/views/expenses/create.blade.php ENDPATH**/ ?>