<?php $__env->startSection('content'); ?>
<!-- <div class="container">
    <div class="card">
        <div class="card-header d-flex flex-row align-items-center justify-content-between">
            <ol class="breadcrumb m-0 p-0">
                <li class="breadcrumb-item"><a href="<?php echo e(implode('/', ['','monthly_fillings'])); ?>"> Monthly Fillings</a></li>
                <li class="breadcrumb-item"><?php echo app('translator')->get('Monthly Filling'); ?> #<?php echo e($monthlyFilling->id); ?></li>
            </ol>

            <a href="<?php echo e(route('monthly_fillings.index', [])); ?>" class="btn btn-light"><i class="fa fa-caret-left"></i> Back</a>
        </div>

        <div class="card-body">
            <table class="table table-striped">
                <tbody>
                    <tr>
                        <th scope="row">ID:</th>
                        <td><?php echo e($monthlyFilling->id); ?></td>
                    </tr>
                    <tr>
                        <th scope="row">Customer:</th>
                        <td><a href="<?php echo e(implode('/', ['','customers',$monthlyFilling->customer_id ?: 0])); ?>" class="text-dark"><?php echo e($monthlyFilling?->customer?->name ?: "(blank)"); ?></a></td>
                    </tr>
                    <tr>
                        <th scope="row">Month:</th>
                        <td><?php echo e(date('M - Y',strtotime($monthlyFilling->month)) ?: "(blank)"); ?></td>
                    </tr>
                    <tr>
                        <th scope="row">Standard Sales:</th>
                        <td><?php echo e($monthlyFilling->standard_sales ?: "(blank)"); ?></td>
                    </tr>
                    <tr>
                        <th scope="row">Deemed Sales:</th>
                        <td><?php echo e($monthlyFilling->deemed_sales ?: "(blank)"); ?></td>
                    </tr>
                    <tr>
                        <th scope="row">Zero Rated Sales:</th>
                        <td><?php echo e($monthlyFilling->zero_rated_sales ?: "(blank)"); ?></td>
                    </tr>
                    <tr>
                        <th scope="row">Exempted Sales:</th>
                        <td><?php echo e($monthlyFilling->exempted_sales ?: "(blank)"); ?></td>
                    </tr>
                    <tr>
                        <th scope="row">Purchases:</th>
                        <td><?php echo e($monthlyFilling->purchases ?: "(blank)"); ?></td>
                    </tr>
                </tr>
                <tr>
                    <th scope="row">Non VAT Purchases:</th>
                    <td><?php echo e($monthlyFilling->non_vat_purchases ?: "(blank)"); ?></td>
                </tr>
            </tr>
            <tr>
                <th scope="row">Imports:</th>
                <td><?php echo e($monthlyFilling->imports ?: "(blank)"); ?></td>
            </tr>
            <tr>
                <th scope="row">Net Sales:</th>
                <td><?php echo e($monthlyFilling->net_sales ?: "(blank)"); ?></td>
            </tr>
            <tr>
                <th scope="row">Output Vat:</th>
                <td><?php echo e($monthlyFilling->output_vat ?: "(blank)"); ?></td>
            </tr>
            <tr>
                <th scope="row">Gross Sales:</th>
                <td><?php echo e($monthlyFilling->gross_sales ?: "(blank)"); ?></td>
            </tr>
            <tr>
                <th scope="row">Filling Date:</th>
                <td><?php echo e($monthlyFilling->filling_date ?: "(blank)"); ?></td>
            </tr>
            <tr>
                <th scope="row">Created at</th>
                <td><?php echo e(Carbon\Carbon::parse($monthlyFilling->created_at)->format('d/m/Y H:i:s')); ?></td>
            </tr>
            <tr>
                <th scope="row">Updated at</th>
                <td><?php echo e(Carbon\Carbon::parse($monthlyFilling->updated_at)->format('d/m/Y H:i:s')); ?></td>
            </tr>
        </tbody>
    </table>

</div>

<div class="card-footer d-flex flex-column flex-md-row align-items-center justify-content-end">
    <a href="<?php echo e(route('monthly_fillings.edit', $monthlyFilling->id)); ?>" class="btn btn-info text-nowrap me-1"><i class="fa fa-edit"></i> <?php echo app('translator')->get('Edit'); ?></a>
    <form action="<?php echo e(route('monthly_fillings.destroy', $monthlyFilling->id)); ?>" method="POST" class="m-0 p-0">
        <?php echo csrf_field(); ?>
        <?php echo method_field('DELETE'); ?>
        <button type="submit" class="btn btn-danger text-nowrap"><i class="fa fa-trash"></i> <?php echo app('translator')->get('Delete'); ?></button>
    </form>
</div>
</div>
</div> -->
<div class="card">
    <div class="card-header d-flex flex-row align-items-center justify-content-between">
        <h5><?php echo e($monthlyFilling->customer->name); ?></h5>

        <span class="badge bg-primary"><?php echo e(date('M - Y',strtotime($monthlyFilling->month))); ?></span>
    </div>
    <div class="card-body">
        <table class="table table-striped">
            <thead>
                <th>Item</th>
                <th class="text-end">Amount</th>
            </thead>
            <tbody>
                <tr>
                    <td>Standard Sales</td>
                    <td class="text-end"><?php echo e(number_format($monthlyFilling->standard_sales)); ?></td>
                </tr>
                <tr>
                    <td>Exempted Sales</td>
                    <td class="text-end"><?php echo e(number_format($monthlyFilling->exempted_sales)); ?></td>
                </tr>
                <tr>
                    <td>Zero Rated Sales</td>
                    <td class="text-end"><?php echo e(number_format($monthlyFilling->zero_rated_sales)); ?></td>
                </tr>
                <tr>
                    <td>Deemed Sales</td>
                    <td class="text-end"><?php echo e(number_format($monthlyFilling->deemed_sales)); ?></td>
                </tr>
                <tr>
                    <th>Output VAT</th>
                    <th class="text-end"><?php echo e(number_format($monthlyFilling->standard_sales * 0.18)); ?></th>
                </tr>
                <tr>
                    <td>Standard Purchases</td>
                    <td class="text-end"><?php echo e(number_format($monthlyFilling->purchases)); ?></td>
                </tr>
                <tr>
                    <td>Non VAT Purchases</td>
                    <td class="text-end"><?php echo e(number_format($monthlyFilling->non_vat_purchases)); ?></td>
                </tr>
                <tr>
                    <td>Imports</td>
                    <td class="text-end"><?php echo e(number_format($monthlyFilling->imports)); ?></td>
                </tr>
                <tr>
                    <th>Input VAT</th>
                    <th class="text-end"><?php echo e(number_format(($monthlyFilling->purchases * 0.18) + ($monthlyFilling->imports * 0.18))); ?></th>
                </tr>
                    <td>Resultant VAT</td>
                    <td class="text-end"><?php echo e(number_format(($monthlyFilling->standard_sales * 0.18) - (($monthlyFilling->purchases * 0.18) + ($monthlyFilling->imports * 0.18)))); ?></td>
                </tr>
            </tbody>
        </table>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u380932374/domains/wykaconsults.com/public_html/subdomains/admin/resources/views/monthly_fillings/show.blade.php ENDPATH**/ ?>